% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodesic_exact.R
\name{geodesic_direct}
\alias{geodesic_direct}
\alias{geodesic_inverse}
\alias{geodesic_path}
\alias{geodesic_line}
\alias{geodesic_distance}
\alias{geodesic_distance_matrix}
\title{Geodesic calculations on the WGS84 ellipsoid}
\usage{
geodesic_direct(x, azi, s)

geodesic_inverse(x, y)

geodesic_path(x, y, n = 100L)

geodesic_line(x, azi, distances)

geodesic_distance(x, y)

geodesic_distance_matrix(x, y = NULL)
}
\arguments{
\item{x}{A two-column matrix or data frame of starting coordinates
(longitude, latitude) in decimal degrees.}

\item{azi}{Numeric vector of azimuths (bearings) in degrees, measured
clockwise from north.}

\item{s}{Numeric vector of distances in meters.}

\item{y}{A two-column matrix or data frame of ending coordinates
(longitude, latitude) in decimal degrees.}

\item{n}{Integer number of points to generate along the path (including
start and end points).}

\item{distances}{Numeric vector of distances from the starting point in meters.}
}
\value{
\itemize{
\item \code{geodesic_direct()}: Data frame with columns:
\itemize{
\item \code{lon1}, \code{lat1}: Starting coordinates
\item \code{azi1}: Starting azimuth (degrees)
\item \code{s12}: Distance (meters)
\item \code{lon2}, \code{lat2}: Destination coordinates
\item \code{azi2}: Azimuth at destination (degrees)
\item \code{m12}: Reduced length (meters)
\item \code{M12}, \code{M21}: Geodesic scale factors
\item \code{S12}: Area under geodesic (square meters)
}
\item \code{geodesic_inverse()}: Data frame with columns:
\itemize{
\item \code{lon1}, \code{lat1}: Starting coordinates
\item \code{lon2}, \code{lat2}: Ending coordinates
\item \code{s12}: Distance (meters)
\item \code{azi1}: Azimuth at start (degrees)
\item \code{azi2}: Azimuth at end (degrees)
\item \code{m12}: Reduced length (meters)
\item \code{M12}, \code{M21}: Geodesic scale factors
\item \code{S12}: Area under geodesic (square meters)
}
\item \code{geodesic_path()}: Data frame with columns:
\itemize{
\item \code{lon}, \code{lat}: Coordinates along the path
\item \code{azi}: Azimuth at each point (degrees)
\item \code{s}: Distance from start (meters)
}
\item \code{geodesic_line()}: Data frame with columns:
\itemize{
\item \code{lon}, \code{lat}: Coordinates at specified distances
\item \code{azi}: Azimuth at each point (degrees)
\item \code{s}: Distance from start (meters)
}
\item \code{geodesic_distance()}: Numeric vector of distances in meters (pairwise).
\item \code{geodesic_distance_matrix()}: Matrix of distances in meters.
}
}
\description{
Solve geodesic problems on the WGS84 ellipsoid using exact algorithms.
These functions provide high-precision solutions for:
\itemize{
\item Finding destination points given start, azimuth, and distance (direct problem)
\item Finding distance and azimuths between two points (inverse problem)
\item Generating points along geodesic paths
\item Computing distance matrices
}
}
\details{
These functions use the exact geodesic algorithms from GeographicLib,
which provide full double-precision accuracy for all points on the
WGS84 ellipsoid.

The \strong{direct problem} finds the destination given a starting point,
initial azimuth (bearing), and distance. This is useful for navigation
and creating buffers.

The \strong{inverse problem} finds the shortest path (geodesic) between two
points and returns the distance and azimuths at both endpoints.

The azimuth is measured in degrees from north, with positive values
clockwise (east) and negative values counter-clockwise (west).
The range is -180° to 180° (e.g., 90° = east, -90° = west, 180° or -180° = south).
}
\examples{
# Direct problem: Where do you end up starting from London,
# heading east for 1000 km?
geodesic_direct(c(-0.1, 51.5), azi = 90, s = 1000000)

# Inverse problem: Distance from London to New York
geodesic_inverse(c(-0.1, 51.5), c(-74, 40.7))

# Generate a great circle path
path <- geodesic_path(c(-0.1, 51.5), c(-74, 40.7), n = 100)
head(path)

# Multiple distances along a bearing
geodesic_line(c(-0.1, 51.5), azi = 45, distances = c(100, 500, 1000) * 1000)
}
