% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocentric.R
\name{geocentric_fwd}
\alias{geocentric_fwd}
\alias{geocentric_rev}
\title{Convert between geodetic and geocentric (ECEF) coordinates}
\usage{
geocentric_fwd(x, h = 0)

geocentric_rev(x, y, z)
}
\arguments{
\item{x}{For forward conversion: a two or three-column matrix or data frame
of coordinates (longitude, latitude) or (longitude, latitude, height) in
decimal degrees and meters. Can also be a list with lon, lat, and
optionally h components.
For reverse conversion: numeric vector of X coordinates in meters.}

\item{h}{Numeric vector of heights above the ellipsoid in meters. Default is 0.}

\item{y}{Numeric vector of Y coordinates in meters for reverse conversion.}

\item{z}{Numeric vector of Z coordinates in meters for reverse conversion.}
}
\value{
Data frame with columns:
\itemize{
\item For forward conversion:
\itemize{
\item \code{X}, \code{Y}, \code{Z}: Geocentric ECEF coordinates in meters
\item \code{lon}, \code{lat}, \code{h}: Input coordinates (echoed)
}
\item For reverse conversion:
\itemize{
\item \code{lon}: Longitude in decimal degrees
\item \code{lat}: Latitude in decimal degrees
\item \code{h}: Height above ellipsoid in meters
\item \code{X}, \code{Y}, \code{Z}: Input coordinates (echoed)
}
}
}
\description{
Convert geographic coordinates (longitude/latitude/height) to geocentric
Earth-Centered Earth-Fixed (ECEF) Cartesian coordinates (X/Y/Z), or convert
ECEF coordinates back to geographic coordinates.
}
\details{
The geocentric coordinate system (also called ECEF - Earth-Centered
Earth-Fixed) is a Cartesian coordinate system with:
\itemize{
\item Origin at the Earth's center of mass
\item X-axis pointing to the intersection of the equator and prime meridian
\item Y-axis pointing to the intersection of the equator and 90°E
\item Z-axis pointing to the North Pole
}

This coordinate system is commonly used in GPS and satellite applications.
All calculations use the WGS84 ellipsoid.
}
\examples{
# Convert London to ECEF
geocentric_fwd(c(-0.1, 51.5))

# With height
geocentric_fwd(c(-0.1, 51.5), h = 100)

# Multiple points
pts <- cbind(lon = c(0, 90, -90), lat = c(0, 0, 0))
geocentric_fwd(pts)

# Round-trip
fwd <- geocentric_fwd(c(-0.1, 51.5, 100))
geocentric_rev(fwd$X, fwd$Y, fwd$Z)
}
\seealso{
\code{\link[=utmups_fwd]{utmups_fwd()}} for projected coordinates.
}
