% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dms.R
\name{dms_decode}
\alias{dms_decode}
\alias{dms_decode_latlon}
\alias{dms_decode_angle}
\alias{dms_decode_azimuth}
\alias{dms_encode}
\alias{dms_split}
\alias{dms_combine}
\title{Convert between degrees and DMS (degrees, minutes, seconds) representation}
\usage{
dms_decode(x)

dms_decode_latlon(dmsa, dmsb, longfirst = FALSE)

dms_decode_angle(x)

dms_decode_azimuth(x)

dms_encode(x, prec = 5L, component = NULL, indicator = "none", sep = "")

dms_split(x, seconds = FALSE)

dms_combine(d, m = 0, s = 0)
}
\arguments{
\item{x}{Character vector of DMS strings to parse, or numeric vector of
angles in degrees to encode.}

\item{dmsa, dmsb}{Character vectors of DMS strings for latitude/longitude
parsing.}

\item{longfirst}{Logical; if TRUE, assume longitude is given before
latitude when no hemisphere designators are present.}

\item{prec}{Integer precision for output strings. For \code{dms_encode()} this
is the number of digits after the decimal point for the trailing
component. For automatic encoding, prec < 2 gives degrees, prec 2-3
gives minutes, prec >= 4 gives seconds.}

\item{component}{Character indicating the trailing unit: \code{"degree"},
\code{"minute"}, or \code{"second"}.}

\item{indicator}{Character indicating formatting: \code{"none"} (signed result),
\code{"latitude"} (trailing N/S), \code{"longitude"} (trailing E/W),
\code{"azimuth"} (0-360, no sign), or \code{"number"} (plain number).}

\item{sep}{Character to use as DMS separator instead of d, ', ".
Use \code{":"} for colon-separated output.}

\item{seconds}{Logical; if TRUE, split into degrees, minutes, and seconds.
If FALSE (default), split into degrees and minutes only.}

\item{d, m, s}{Numeric vectors of degrees, minutes, and seconds.}
}
\value{
\itemize{
\item \code{dms_decode()}: Data frame with columns \code{angle} (degrees) and \code{indicator}
(0=NONE, 1=LATITUDE, 2=LONGITUDE)
\item \code{dms_decode_latlon()}: Data frame with columns \code{lat} and \code{lon} (degrees)
\item \code{dms_decode_angle()}: Numeric vector of angles in degrees
\item \code{dms_decode_azimuth()}: Numeric vector of azimuths in degrees (range
-180 to 180)
\item \code{dms_encode()}: Character vector of DMS strings
\item \code{dms_split()}: Data frame with columns \code{d}, \code{m}, and optionally \code{s}
\item \code{dms_combine()}: Numeric vector of angles in degrees
}
}
\description{
Parse strings representing degrees, minutes, and seconds and return the
angle in degrees. Format an angle in degrees as degrees, minutes, and
seconds strings.
}
\details{
\subsection{Input Formats}{

The \code{dms_decode()} function accepts various input formats:
\itemize{
\item Degrees, minutes, seconds: \verb{"40d26'47\\"N"}, \verb{"40°26'47\\"N"}
\item Degrees and minutes: \code{"40d26.783'N"}, \code{"40:26.783N"}
\item Decimal degrees: \code{"40.446N"}, \code{"-40.446"}
\item Colon-separated: \code{"40:26:47"}, \code{"-74:0:21.5"}
}

Hemisphere designators (N, S, E, W) can appear at the beginning or end.
Many Unicode symbols are supported for degrees, minutes, and seconds.
See the GeographicLib DMS documentation for the full list of accepted symbols.
}

\subsection{Precision and Components}{

For \code{dms_encode()}, the \code{prec} parameter controls decimal places in the
trailing component:
\itemize{
\item \code{prec = 0}: whole degrees/minutes/seconds
\item \code{prec = 1}: one decimal place
\item \code{prec = 2}: two decimal places, etc.
}

For automatic component selection:
\itemize{
\item \code{prec < 2}: output in degrees
\item \verb{prec = 2, 3}: output in degrees and minutes
\item \code{prec >= 4}: output in degrees, minutes, and seconds
}
}
}
\examples{
# Parse DMS strings
dms_decode("40d26'47\"N")
dms_decode(c("40:26:47", "-74:0:21.5", "51d30'N"))

# Parse latitude/longitude pairs
dms_decode_latlon("40d26'47\"N", "74d0'21.5\"W")

# Parse angles (no hemisphere designator)
dms_decode_angle(c("45:30:0", "123d45'6\""))

# Parse azimuths (E/W allowed)
dms_decode_azimuth(c("45:30:0", "90W", "45E"))

# Encode to DMS strings
dms_encode(40.446, indicator = "latitude")
dms_encode(-74.006, indicator = "longitude")
dms_encode(c(40.446, -74.006), prec = 2)

# With colon separator
dms_encode(40.446, sep = ":")

# Split angle into components
dms_split(40.446)
dms_split(c(40.446, -74.006), seconds = TRUE)

# Combine components to decimal degrees
dms_combine(40, 26, 47)
dms_combine(d = c(40, -74), m = c(26, 0), s = c(47, 21.5))
}
\seealso{
\code{\link[=geocoords_parse]{geocoords_parse()}} for parsing complete coordinate strings
}
