% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_em_vec.R
\name{get_em_vec}
\alias{get_em_vec}
\title{convert a list of im objects to a vector}
\usage{
get_em_vec(
  em,
  outcome_pixel_count = NULL,
  time_after = TRUE,
  entire_window = NULL,
  lag
)
}
\arguments{
\item{em}{column of a hyperframe that summarizes effect modifier data. In the form of `hyperframe$column`.}

\item{outcome_pixel_count}{A list of integer-valued pixel images giving outcome event counts per spatial pixel,
typically obtained from `pixel_count_ppp()`.}

\item{time_after}{whether to include one unit time difference between treatment and outcome. By default = TRUE}

\item{entire_window}{owin object (the entire region of interest). If given, then the values outside the region will be set to `NA`.}

\item{lag}{integer that specifies lags to calculate causal estimates}
}
\description{
`get_em_vec()` get the vector form of a column of a hyperframe that summarizes the effect modifier data in heterogeneity analysis
}
\details{
The function `get_em_vec()` get the vector form of the effect modifier in the heterogeneity analysis. It is useful
if you want to construct the variance matrix `E_mat` that is passed to the function `get_cate()`
}
