% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dist_line.R
\name{get_dist_line}
\alias{get_dist_line}
\title{Get distance maps from lines and polygons}
\usage{
get_dist_line(
  window,
  path_to_shapefile = NULL,
  line_data = NULL,
  mile = FALSE,
  resolution = NULL,
  ndim = NULL,
  preprocess = TRUE,
  unit_scale = 1000
)
}
\arguments{
\item{window}{owin object}

\item{path_to_shapefile}{path to shapefile}

\item{line_data}{sfc_MULTILINESTRING file (If available. If not, `get_dist_line()` creates it from a shapefile.)}

\item{mile}{logical. `mile` specifies whether to return the output in miles instead of kilometers (by default,  FALSE).}

\item{resolution}{resolution of raster objects (distance map) (in km; by default, 1). Ignored if ndim is set.}

\item{ndim}{number of pixels for both dimensions (e.g., 256 for 256x256). If set, resolution is ignored.}

\item{preprocess}{logical. `preprocess` specifies whether to first pick the potentially closest point.
It is recommended to set `preprocess = TRUE` if users need to obtain distances from many points.}

\item{unit_scale}{set to the same value as the parameter in `get_window()` function.
This parameter converts the coordinate values so that they alingn with the unit (km) of the owin object}
}
\value{
an im object
}
\description{
`get_dist_line()` generates a distance map from lines and polygons.
}
\details{
The function ensures spatial integrity by automatically projecting the
\code{line_data} or shapefile to match the Coordinate Reference System (CRS)
of the \code{window}.
}
