% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_base_dens.R
\name{get_base_dens}
\alias{get_base_dens}
\title{Get the baseline density}
\usage{
get_base_dens(
  window,
  ndim = 128,
  resolution = NULL,
  out_data = NULL,
  out_coordinates = c("longitude", "latitude"),
  input_crs = 4326,
  unit_scale = 1000
)
}
\arguments{
\item{window}{owin object}

\item{ndim}{the number of dimensions of grid cells (ndim^2). By default, ndim = 128.}

\item{resolution}{the resolution in km per pixel. If specified, overrides `ndim`.
For example, `resolution = 5` creates ~5km x 5km grid cells.}

\item{out_data}{dataframe}

\item{out_coordinates}{vector of column names of longitudes and latitudes (in this order)}

\item{input_crs}{the CRS of the input \code{coordinates}. Defaults to \code{4326}}

\item{unit_scale}{parameter to convert meters to kilometers
(WGS84 decimal degrees). The function will transform these to match the \code{window} projection}
}
\value{
an im object of baseline density
}
\description{
`get_base_dens()` takes a dataframe and
returns the baseline densities using Scott's rule of thumb (out-of-sample data).
}
