% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dx_outpred.R
\name{dx_outpred}
\alias{dx_outpred}
\title{Perform out-of-sample prediction}
\usage{
dx_outpred(
  hfr,
  ratio,
  dep_var,
  indep_var,
  ndim = 128,
  resolution = NULL,
  window
)
}
\arguments{
\item{hfr}{hyperframe}

\item{ratio}{numeric. ratio between training and test sets}

\item{dep_var}{dependent variables}

\item{indep_var}{independent variables}

\item{ndim}{the number of grids. By default, `128` (128 x 128).}

\item{resolution}{the resolution in km per pixel. If specified, overrides `ndim`.
For example, `resolution = 5` creates ~5km x 5km grid cells.}

\item{window}{owin object}
}
\value{
list of the following:
     * `indep_var`: independent variables
     * `coef`: coefficients
     * `intens_grid_cells`: im object of observed densities for each time period
     * `estimated_counts`: the number of events that is estimated by the poisson point process model for each time period
     * `sum_log_intens`: the sum of log intensities for each time period
     * `training_row_max`: the max row ID of the training set
}
\description{
`dx_outpred()` performs out-of-sample prediction
(separating data into training and test sets).
It assumes that training and test sets have the same window.
}
