% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gb-get-metadata.R
\encoding{UTF-8}
\name{gb_get_metadata}
\alias{gb_get_metadata}
\alias{gb_get_meta}
\title{Get metadata of individual country files from geoBoundaries}
\source{
geoBoundaries API Service \url{https://www.geoboundaries.org/api.html}.
}
\usage{
gb_get_metadata(
  country = "all",
  adm_lvl = "all",
  release_type = c("gbOpen", "gbHumanitarian", "gbAuthoritative")
)
}
\arguments{
\item{country}{A character vector of country codes. It can be either
\code{"all"} (that would return the data for all countries), a vector of country
names or ISO3 country codes. See also \code{\link[countrycode:countrycode]{countrycode::countrycode()}}.}

\item{adm_lvl}{Type of boundary. Accepted values are \code{"all"} (all
available boundaries) or the ADM level (\code{"adm0"} is the country boundary,
\code{"adm1"} is the first level of sub-national boundaries, \code{"adm2"} is the
second level, and so on). Upper-case versions (\code{"ADM1"}) and the number of
the level (\verb{1, 2, 3, 4, 5}) are also accepted.}

\item{release_type}{One of \code{"gbOpen"}, \code{"gbHumanitarian"},
\code{"gbAuthoritative"}. For most users, we suggest using \code{"gbOpen"}
(the default), as it is CC-BY 4.0 compliant and can be used for most
purposes so long as attribution is provided:
\itemize{
\item \code{"gbHumanitarian"} files are mirrored from
\href{https://www.unocha.org/}{UN OCHA}, but may have more restrictive
licensing.
\item \code{"gbAuthoritative"} files are mirrored from UN SALB, and cannot be used
for commercial purposes, but are verified through in-country processes.
}}
}
\value{
A \link[tibble:tbl_df-class]{tibble}.
}
\description{
This function returns metadata of the
\href{https://www.geoboundaries.org/api.html}{geoBoundaries API}.
}
\details{
The result is a \link[tibble:tbl_df-class]{tibble} with the following columns:
\itemize{
\item \code{boundaryID}: The ID for this layer, which is a combination of the ISO
code, the boundary type, and a unique identifier for the boundary
generated based on the input metadata and geometry. This only changes if
the underlying data changes.
\item \code{boundaryName}: The name of the country the layer represents.
\item \code{boundaryISO}: ISO-3166-1 (Alpha 3) code for the country.
\item \code{boundaryYearRepresented}: The year, or range of years in \code{"START to END"}
format, which the boundary layers represent.
\item \code{boundaryType}: The type of boundary.
\item \code{boundaryCanonical}: The canonical name of a given boundary.
\item \code{boundarySource}: A comma-separated list of the primary sources for the
boundary.
\item \code{boundarySource}: A comma-separated list of the primary sources for the
boundary.
\item \code{boundaryLicense}: The original license that the dataset was released
under by the primary source.
\item \code{licenseDetail}: Any notes regarding the license.
\item \code{licenseSource}: The URL of the primary source.
\item \code{sourceDataUpdateDate}: The date the source information was integrated
into the geoBoundaries repository.
\item \code{buildDate}: The date the source data was most recently standardized and
built into a geoBoundaries release.
\item \code{Continent}: The continent the country is associated with.
\item \code{UNSDG-region}: The United Nations Sustainable Development Goals (SDG)
region the country is associated with.
\item \code{UNSDG-subregion}: The United Nations Sustainable Development Goals (SDG)
subregion the country is associated with.
\item \code{worldBankIncomeGroup}: The World Bank income group the country is
associated with.
\item \code{admUnitCount}: Count of administrative units in the file.
\item \code{meanVertices}: Mean number of vertices defining the boundaries of each
administrative unit in the layer.
\item \code{minVertices}: Minimum number of vertices defining a boundary.
\item \code{maxVertices}: Maximum number of vertices defining a boundary.
\item \code{minPerimeterLengthKM}: The minimum perimeter length of an administrative
unit in the layer, measured in kilometers (based on a World Equidistant
Cylindrical projection).
\item \code{meanPerimeterLengthKM}: The mean perimeter length of an administrative
unit in the layer, measured in kilometers (based on a World Equidistant
Cylindrical projection).
\item \code{maxPerimeterLengthKM}: The maximum perimeter length of an administrative
unit in the layer, measured in kilometers (based on a World Equidistant
Cylindrical projection).
\item \code{meanAreaSqKM}: The mean area of all administrative units in the layer,
measured in square kilometers (based on a EASE-GRID 2 projection).
\item \code{minAreaSqKM}: The minimum area of an administrative unit in the layer,
measured in square kilometers (based on a EASE-GRID 2 projection).
\item \code{maxAreaSqKM}: The maximum area of an administrative unit in the layer,
measured in square kilometers (based on a EASE-GRID 2 projection).
\item \code{staticDownloadLink}: The static download link for the aggregate zip file
containing all boundary information.
\item \code{gjDownloadURL}: The static download link for the \code{geoJSON}.
\item \code{tjDownloadURL}: The static download link for the \code{topoJSON}.
\item \code{imagePreview}: The static download link for the automatically rendered
\code{PNG} of the layer.
\item \code{simplifiedGeometryGeoJSON}: The static download link for the
simplified \code{geoJSON}.
}
}
\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true") || interactive()) withAutoprint(\{ # examplesIf}
# Get metadata of ADM4 levels

library(dplyr)

gb_get_metadata(adm_lvl = "ADM4") |>
  glimpse()
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=gb_get]{gb_get()}}

Other metadata functions: 
\code{\link{gb_get_max_adm_lvl}()}
}
\concept{metadata functions}
