% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lnpochhammer.R
\name{lnpochhammer}
\alias{lnpochhammer}
\title{Logarithm of the Pochhammer Symbol}
\usage{
lnpochhammer(x, n)
}
\arguments{
\item{x}{numeric.}

\item{n}{positive integer.}
}
\value{
Numeric value. The logarithm of the Pochhammer symbol.
}
\description{
Computes the logarithm of the Pochhammer symbol.
}
\details{
The Pochhammer symbol is given by:
\deqn{ \displaystyle{ (x)_n = \frac{\Gamma(x+n)}{\Gamma(x)} = x (x+1) ... (x+n-1) } }
So, if \eqn{n > 0}:
\deqn{ \displaystyle{ log\left((x)_n\right) = log(x) + log(x+1) + ... + log(x+n-1) } }

If \eqn{n = 0}, \eqn{\displaystyle{ log\left((x)_n\right) = log(1) = 0}}
}
\examples{
lnpochhammer(2, 0)
lnpochhammer(2, 1)
lnpochhammer(2, 3)

}
\seealso{
\code{\link{pochhammer}},
\code{\link{kummer}}
}
\author{
Pierre Santagostini, Nizar Bouhlel
}
