% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misspellings.R
\docType{data}
\name{misspellings}
\alias{misspellings}
\title{A corpus of common misspellings, for examples and practice}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 4505 rows and 2 columns.
}
\source{
\url{https://en.wikipedia.org/wiki/Wikipedia:Lists_of_common_misspellings/For_machines}
}
\usage{
misspellings
}
\description{
This is a \code{tbl_df} mapping misspellings of their words, compiled by
Wikipedia, where it is licensed under the CC-BY SA license. (Three words with
non-ASCII characters were filtered out). If you'd like to reproduce this
dataset from Wikipedia, see the example code below.
}
\examples{

\donttest{
library(rvest)
library(readr)
library(dplyr)
library(stringr)
library(tidyr)

u <- "https://en.wikipedia.org/wiki/Wikipedia:Lists_of_common_misspellings/For_machines"
h <- read_html(u)

misspellings <- h \%>\%
  html_nodes("pre") \%>\%
  html_text() \%>\%
  read_delim(col_names = c("misspelling", "correct"),
                    delim = ">",
                    skip = 1) \%>\%
  mutate(misspelling = str_sub(misspelling,
                                               1, -2)) |>
  separate_rows(correct, sep = ", ") |>
  filter(Encoding(correct) != "UTF-8")
}

}
\keyword{datasets}
