\name{vulnerability}
\alias{vulnerability}
\title{
(Fuzzy) vulnerability
}
\description{
This function computes the index of species vulnerability of Estrada et al. (2011), using either crisp (presence/absence, i.e. ones and zeros) or fuzzy (\code{\link{Fav}}ourability, between zero and one) values, taking into account the conservation status of each species. Vulnerability is like a (potential) richness index in which more vulnerable species (i.e., those with a more threatened conservation status) have higher weight.
}
\usage{
vulnerability(data, sp.cols = 1:ncol(data), categories, na.rm = TRUE)
}
\arguments{
  \item{data}{a numeric vector, matrix or data frame containing the presence/absence (ones and zeros) or the \code{\link{Fav}}ourability (fuzzy presence, between zero and one) values for the target species.}
  \item{sp.cols}{names or index numbers of the columns of 'data' that contain the species values for which to compute vulnerability. The default is to use all columns.}
  \item{categories}{numeric vector of the same length as 'sp.cols' (or of length 1 if 'data' is a vector) indicating the IUCN Red List category of each species. This vector should be provided in the same order as the columns in data[ , sp.cols]. See Details.}
  \item{na.rm}{logical value indicating whether NA values should be removed before the computation.}
}
\details{
The numeric values for the 'categories' argument are suggested by Estrada et al. (2011) to be as follows for each species, according to its IUCN Red List category (available at https://www.iucnredlist.org):

Critically endangered (CR): 16

Endangered (EN): 8

Vulnerable (VU): 4

Near Threatened (NT): 2

Least Concern (LC): 1

Data Deficient (DD): 1

Not evaluated (NE): 0

These values follow an exponential scale, because a critically endangered species is generally considered more important than two endangered species, an endangered species more important than two vulnerable species, and so on (Estrada et al. 2011).
}
\value{
This function returns a numeric vulnerability value for each value or each row in 'data'.
}
\references{
Estrada A., Real R. & Vargas J.M. (2011) Assessing coincidence between priority conservation areas for vertebrate groups in a Mediterranean hotspot. Biological Conservation, 144: 1120-1129
}
\author{A. Marcia Barbosa}
\seealso{
\code{\link{rarity}}
}
\examples{
data(rotif.env)

# note the 'categories' below are made up, as rotifers are not on yet redlisted
# see Details above for how to get actual values for your species

vulnerability(rotif.env[ , 18], categories = 8)

vulnerability(rotif.env, sp.cols = "Abrigh", categories = 8)

vulnerability(rotif.env, sp.cols = c("Apriod", "Burceo", "Kcochl"), categories = c(8, 16, 2))


# fuzzy vulnerability (from favourability values):

pred <- multGLM(rotif.env, sp.cols = c("Apriod", "Burceo", "Kcochl"), var.cols = 5:17)$predictions

head(pred)

vulnerability(pred, sp.cols = "Apriod_F", categories = 8)

vulnerability(pred, sp.cols = c("Apriod_F", "Burceo_F", "Kcochl_F"), categories = c(8, 16, 2))

}
