% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mine_sweeper.R
\name{mine_sweeper}
\alias{mine_sweeper}
\title{Play the Mine Sweeper game in R}
\usage{
mine_sweeper(width = 10, height = 10, mines = 20, cheat = FALSE)
}
\arguments{
\item{width}{number of grids in horizontal axis}

\item{height}{number of grids in vertical axis}

\item{mines}{number of mines}

\item{cheat}{logical. If \code{TRUE} a matrix indicating the mines will be
printed}
}
\description{
The controls should be familiar to you: Click the left mouse button to dig in
an area, and right button to mark or unmark the area with flags.
}
\note{
Linux/Mac users have to use \code{X11(type = 'Xlib')} or the Cairo
  graphics device \code{Cairo()} in the package \pkg{cairoDevice}.
}
\examples{
## should use Xlib for the x11() device under *nix, e.g
if (interactive()) {
    if (.Platform$OS.type == "windows")
        x11() else x11(type = "Xlib")
    mine_sweeper()
}
}
\references{
\url{https://en.wikipedia.org/wiki/Minesweeper_(computer_game)}
}
\author{
Yixuan Qiu \email{yixuan.qiu@cos.name}
}
