% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_german_umlauts.R
\name{get_german_umlauts}
\alias{get_german_umlauts}
\title{Get German Umlauts}
\usage{
get_german_umlauts(
  which = NULL,
  type = c("utf-8", "latex"),
  strip_names = TRUE
)
}
\arguments{
\item{which}{A character vector specifying a subset of the result vector.}

\item{type}{UTF-8 or LaTeX?}

\item{strip_names}{Return an unnamed vector?}
}
\value{
A (possibly named) vector of UTF-8 representations of german umlauts.
}
\description{
I often need German umlauts in reporting. So I need either a UTF-8 or LaTeX
representation.
}
\examples{
get_german_umlauts()
get_german_umlauts(type = "latex")
get_german_umlauts(strip_names = FALSE)
get_german_umlauts(which = c("sz", "Ae"))
try(get_german_umlauts(which = c("sz", "foo", "Ae", "bar")))
paste0("Cologne is K", get_german_umlauts("oe"), "ln. In LaTeX it's K",
       get_german_umlauts("oe", "latex"), "ln")
}
\seealso{
Other German umlaut converters: 
\code{\link{convert_umlauts_to_ascii}()},
\code{\link{convert_umlauts_to_tex}()},
\code{\link{convert_umlauts_to_utf8}()}
}
\concept{German umlaut converters}
