% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{settings}
\alias{settings}
\title{Get settings value by dot-notation key}
\usage{
settings(key = NULL, default = NULL, settings_file = NULL)
}
\arguments{
\item{key}{Character. Dot-notation key path (e.g., "notebooks" or
"directories.notebooks" or "connections.db.host"). If NULL, returns entire settings.}

\item{default}{Optional default value if key is not found (default: NULL)}

\item{settings_file}{Settings file path (default: checks "settings.yml" then "settings.yml")}
}
\value{
The settings value, or default if not found. In interactive sessions,
nested structures are pretty-printed and returned invisibly.
}
\description{
Framework's primary configuration helper that supports both flat and hierarchical
key access using dot notation. Automatically checks common locations for
directory settings. Pretty-prints nested structures in interactive sessions.
}
\details{
For directory settings, the function checks multiple locations:
\itemize{
\item Direct: \code{settings("notebooks")} checks \code{directories$notebooks}, then \code{options$notebook_dir}
\item Explicit: \code{settings("directories.notebooks")} checks only \code{directories$notebooks}
}

\strong{File Discovery:}
\itemize{
\item Checks \code{settings.yml} first (Framework's preferred convention)
\item Falls back to \code{settings.yml} if settings.yml not found
\item You can override with explicit \code{settings_file} parameter
}

\strong{Output Behavior:}
\itemize{
\item Interactive sessions: Pretty-prints nested lists/structures and returns invisibly
\item Non-interactive (scripts): Returns raw value without printing
\item Simple values: Always returned directly without modification
}
}
\examples{
\donttest{
if (FALSE) {
# Get notebook directory (checks both locations)
settings("notebooks")

# Get explicit nested setting
settings("directories.notebooks")
settings("connections.db.host")

# Get entire section
settings("directories")  # Returns all directory settings
settings("connections")  # Returns all connection settings

# View entire settings
settings()  # Returns full configuration

# With default value
settings("missing_key", default = "fallback")
}
}

}
