% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzzz.R
\name{Csurv}
\alias{Csurv}
\title{Survival probability conditional to the observed data estimation for correlated right censored data.}
\usage{
Csurv(
  Y,
  M,
  censor,
  group = NULL,
  t = 0,
  w,
  knots = 10,
  kappa = 10000,
  method = "marg",
  RandDist = "Gamma",
  hazard = "Splines",
  maxit = 300
)
}
\arguments{
\item{Y}{a numeric vector of event-times or observed times.}

\item{M}{a numeric vector of (bio)marker or risk score values.}

\item{censor}{a vector of censoring indicator, \code{1} if event, \code{0} otherwise.}

\item{group}{a categorical vector of group/cluster.}

\item{t}{a scalar time for prediction. The default value is \code{0}.}

\item{w}{a scalar window for prediction.}

\item{knots}{a scalar for specifying the number of knots to use. Value required in the penalized likelihood estimation. It corresponds to the (knots+2) splines functions for the approximation of the hazard or the survival functions. Rondeau, et al. (2012) suggested that the number of knots must be between 4 and 20. The default is \code{10}.}

\item{kappa}{a positive smoothing parameter value for the penalized likelihood estimation. The defaults is "\code{10000}".}

\item{method}{a character string specifying prediction method applied on model. The possible options are "\code{cox}" for the classical Cox; "\code{marg}" for  marginal and "\code{cond}" conditional prediction methods on shared models. The default is "\code{cond}".}

\item{RandDist}{a character string to state the distribution of random effect: "\code{Gamma}" for a gamma distribution, "\code{LogN}" for a log-normal distribution. Default is "\code{Gamma}".}

\item{hazard}{types of hazard functions: "\code{Splines}" represents a semi-parametric hazard function using equidistant intervals and is estimated via penalized likelihood, "\code{Splines-per}" uses percentiles instead of equidistant intervals, "\code{Piecewise-per}" is a piecewise constant hazard function based on percentiles, "\code{Piecewise-equi}" is a piecewise constant hazard using equidistant intervals, and "\code{Weibull}" is a fully parametric hazard function based on the Weibull distribution. "\code{Splines}" is used as the default setting.}

\item{maxit}{maximum number of iterations. The default is \code{300}.}
}
\value{
Return vector of estimated event status and its complement.
}
\description{
Survival probability conditional to the observed data estimation for correlated right censored data.
}
\references{
Beyene, K. M., and Chen, D. G. (2024). Time-dependent receiver operating characteristic curve estimator for correlated right-censored time-to-event data. \emph{Statistical Methods in Medical Research}, 33(1), 162-181.

Beyene, K.M. and El Ghouch A. (2020). Smoothed time-dependent receiver operating characteristic curve for right censored survival data. \emph{Statistics in Medicine}. 39: 3373-3396.

Rondeau, V., Marzroui, Y., & Gonzalez, J. R. (2012). frailtypack: an R package for the analysis of correlated survival data with frailty models using penalized likelihood estimation or parametrical estimation. \emph{Journal of Statistical Software}, 47, 1-28.
}
\keyword{internal}
