% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segm.R, R/sf_mesh.R, R/sp_mesh.R
\name{fm_as_segm}
\alias{fm_as_segm}
\alias{fm_as_segm_list}
\alias{fm_as_segm.fm_segm}
\alias{fm_as_segm.inla.mesh.segment}
\alias{fm_as_segm.sfg}
\alias{fm_as_segm.sfc_POINT}
\alias{fm_as_segm.sfc_LINESTRING}
\alias{fm_as_segm.sfc_MULTILINESTRING}
\alias{fm_as_segm.sfc_POLYGON}
\alias{fm_as_segm.sfc_MULTIPOLYGON}
\alias{fm_as_segm.sfc_GEOMETRY}
\alias{fm_as_segm.sf}
\alias{fm_as_segm.matrix}
\alias{fm_as_segm.SpatialPoints}
\alias{fm_as_segm.SpatialPointsDataFrame}
\alias{fm_as_segm.Line}
\alias{fm_as_segm.Lines}
\alias{fm_as_segm.SpatialLines}
\alias{fm_as_segm.SpatialLinesDataFrame}
\alias{fm_as_segm.SpatialPolygons}
\alias{fm_as_segm.SpatialPolygonsDataFrame}
\alias{fm_as_segm.Polygons}
\alias{fm_as_segm.Polygon}
\title{Convert objects to \code{fm_segm}}
\usage{
fm_as_segm(x, ...)

fm_as_segm_list(x, ...)

\method{fm_as_segm}{fm_segm}(x, ...)

\method{fm_as_segm}{inla.mesh.segment}(x, ...)

\method{fm_as_segm}{sfg}(x, ...)

\method{fm_as_segm}{sfc_POINT}(x, reverse = FALSE, grp = NULL, is.bnd = TRUE, ...)

\method{fm_as_segm}{sfc_LINESTRING}(x, join = TRUE, grp = NULL, reverse = FALSE, ...)

\method{fm_as_segm}{sfc_MULTILINESTRING}(x, join = TRUE, grp = NULL, reverse = FALSE, ...)

\method{fm_as_segm}{sfc_POLYGON}(x, join = TRUE, grp = NULL, ...)

\method{fm_as_segm}{sfc_MULTIPOLYGON}(x, join = TRUE, grp = NULL, ...)

\method{fm_as_segm}{sfc_GEOMETRY}(x, grp = NULL, join = TRUE, ...)

\method{fm_as_segm}{sf}(x, ...)

\method{fm_as_segm}{matrix}(
  x,
  reverse = FALSE,
  grp = NULL,
  is.bnd = FALSE,
  crs = NULL,
  closed = FALSE,
  ...
)

\method{fm_as_segm}{SpatialPoints}(x, reverse = FALSE, grp = NULL, is.bnd = TRUE, closed = FALSE, ...)

\method{fm_as_segm}{SpatialPointsDataFrame}(x, ...)

\method{fm_as_segm}{Line}(x, reverse = FALSE, grp = NULL, crs = NULL, ...)

\method{fm_as_segm}{Lines}(x, join = TRUE, grp = NULL, crs = NULL, ...)

\method{fm_as_segm}{SpatialLines}(x, join = TRUE, grp = NULL, ...)

\method{fm_as_segm}{SpatialLinesDataFrame}(x, ...)

\method{fm_as_segm}{SpatialPolygons}(x, join = TRUE, grp = NULL, ...)

\method{fm_as_segm}{SpatialPolygonsDataFrame}(x, ...)

\method{fm_as_segm}{Polygons}(x, join = TRUE, crs = NULL, grp = NULL, ...)

\method{fm_as_segm}{Polygon}(x, crs = NULL, ...)
}
\arguments{
\item{x}{Object to be converted.}

\item{...}{Arguments passed on to submethods}

\item{reverse}{logical; When TRUE, reverse the order of the input points.
Default \code{FALSE}}

\item{grp}{if non-null, should be an integer vector of grouping labels for
one for each segment.
Default \code{NULL}}

\item{is.bnd}{logical; if \code{TRUE}, set the boundary flag for the segments.
Default \code{TRUE}}

\item{join}{logical; if \code{TRUE}, join input segments with common vertices.
Default \code{TRUE}}

\item{crs}{A crs object}

\item{closed}{logical; whether to treat a point sequence as a closed polygon.
Default: \code{FALSE}}
}
\value{
An \code{fm_segm} or \code{fm_segm_list} object
}
\description{
Convert objects to \code{fm_segm}
}
\section{Functions}{
\itemize{
\item \code{fm_as_segm()}: Convert an object to \code{fm_segm}.

\item \code{fm_as_segm_list()}: Convert each element, making a \code{fm_segm_list} object

}}
\examples{
fm_as_segm_list(list(
  fm_segm(fmexample$mesh),
  fm_segm(fmexample$mesh, boundary = FALSE)
))

(segm <- fm_segm(fmexample$mesh, boundary = FALSE))
(segm_sfc <- fm_as_sfc(segm))
(fm_as_segm(segm_sfc))

}
\seealso{
\code{\link[=c.fm_segm]{c.fm_segm()}}, \code{\link[=c.fm_segm_list]{c.fm_segm_list()}},
\code{\link[=[.fm_segm_list]{[.fm_segm_list()}}

Other object creation and conversion: 
\code{\link{fm_as_collect}()},
\code{\link{fm_as_fm}()},
\code{\link{fm_as_lattice_2d}()},
\code{\link{fm_as_lattice_Nd}()},
\code{\link{fm_as_mesh_1d}()},
\code{\link{fm_as_mesh_2d}()},
\code{\link{fm_as_mesh_3d}()},
\code{\link{fm_as_sfc}()},
\code{\link{fm_as_tensor}()},
\code{\link{fm_collect}()},
\code{\link{fm_lattice_2d}()},
\code{\link{fm_lattice_Nd}()},
\code{\link{fm_mesh_1d}()},
\code{\link{fm_mesh_2d}()},
\code{\link{fm_segm}()},
\code{\link{fm_simplify}()},
\code{\link{fm_tensor}()}
}
\concept{object creation and conversion}
