% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{dfr_exponential}
\alias{dfr_exponential}
\title{Exponential Distribution (Constant Hazard)}
\usage{
dfr_exponential(lambda = NULL)
}
\arguments{
\item{lambda}{Rate parameter (failure rate). If NULL, must be provided
when calling methods or fitting. Must be positive.}
}
\value{
A \code{dfr_dist} object with analytical rate, cumulative hazard,
and score function.
}
\description{
Creates a DFR distribution with constant failure rate (exponential).
The exponential distribution is "memoryless" - the hazard does not depend
on time, making it appropriate for random failures unrelated to age.
}
\details{
The exponential distribution has:
\itemize{
\item Hazard: \eqn{h(t) = \lambda}
\item Cumulative hazard: \eqn{H(t) = \lambda t}
\item Survival: \eqn{S(t) = e^{-\lambda t}}
\item Mean time to failure: \eqn{1/\lambda}
}
}
\section{Reliability Interpretation}{

Use exponential for:
\itemize{
\item Electronic components during useful life (random failures)
\item Systems with redundancy where failures are independent
\item As a baseline model to test against more complex alternatives
}
}

\examples{
# Component with MTBF of 1000 hours (lambda = 0.001)
comp <- dfr_exponential(lambda = 0.001)

# Survival probability at 500 hours
S <- surv(comp)
S(500)  # ~60.6\%

# Fit to failure data
set.seed(42)
failures <- data.frame(t = rexp(50, rate = 0.001), delta = 1)
solver <- fit(comp)
result <- solver(failures, par = c(0.002))
coef(result)  # Should be close to 0.001

}
