% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feistest.R
\name{feistest}
\alias{feistest}
\title{Artificial Regression Test}
\usage{
feistest(
  model = NA,
  robust = FALSE,
  type = c("all", "art1", "art2", "art3"),
  terms = NULL,
  ...
)
}
\arguments{
\item{model}{an object of class "\code{feis}".}

\item{robust}{logical. If \code{TRUE} uses cluster robust standard errors (Default is \code{FALSE}).}

\item{type}{one of "\code{all}" (the Default), "\code{art1}" for test of FEIS against FE only,
"\code{art2}" for test of FE against RE only, and "\code{art3}" for test of FEIS against RE only
(see also Details).}

\item{terms}{An optional character vector specifying which coefficients should be jointly tested.
By default, all covariates are included in the Wchi-squared test. For "\code{type=art2}", the
slope variable is always included in "\code{terms}".}

\item{...}{further arguments.}
}
\value{
An object of class "\code{feistest}", containing the following elements:
\item{wald_feis}{an object of class "\code{wald.test}" testing
the fixed effects individual slopes model against the conventional fixed effects model
(\code{type="art1"}).}
\item{wald_fe}{an object of class "\code{wald.test}" testing
the fixed effects model against the random effects model (\code{type="art2"}).}
\item{wald_re}{an object of class "\code{wald.test}" testing
the fixed effects individual slopes model against the random effects model (\code{type="art3"}).}
\item{vcov1}{the variance-covariance matrix of CREIS (\code{type="art1"}).}
\item{vcov2}{the variance-covariance matrix of CRE (\code{type="art2"}).}
\item{vcov3}{the variance-covariance matrix of CREIS without the means (\code{type="art3"}).}
\item{CREIS}{an object of class "\code{plm}" (see \code{\link[plm]{plm}}) estimating a Correlated
Random Effect Individual Slope model (\code{type="art1"}).}
\item{CRE}{an object of class "\code{plm}" (see \code{\link[plm]{plm}}) estimating a Correlated
Random Effect model (\code{type="art2"}).}
\item{CREIS2}{an object of class "\code{plm}" (see \code{\link[plm]{plm}}) estimating a
Correlated Random Effect Individual Slope model without including the covariates' means
(\code{type="art3"}).}
\item{call}{the matched call.}
\item{robust}{logical. If \code{TRUE} cluster robust standard errors were used
(Default is \code{FALSE}.}
\item{formula}{an object of class "\code{Formula}" describing the model.}
\item{type}{the type of performed test(s).}
\item{terms}{character vector of covariates are included in the Wchi-squared test.}
}
\description{
Estimates a regression-based Hausman test for fixed effects individual slope models.
}
\details{
The Hausman test can be computed by estimating a correlated random effects model
\insertCite{@see @Wooldridge.2010.384, pp. 328-334, @Ruttenauer.2020}{feisr}. This is achieved by
estimating a Mundlak \insertCite{Mundlak.1978.0}{feisr} specification using random effects models
with \code{\link[plm]{plm}}.
Subsequently, \code{feistest} tests whether the time-constant variables / slope variables are correlated with
the unobserved heterogeneity by using a Wald chi-squared test.

\code{type="art1"} estimates an extended regression-based Hausman test comparing fixed effects
individual slope models and conventional fixed effects models. For \code{art1} the
Mundlak-specification \insertCite{Mundlak.1978.0}{feisr} includes the person-specific averages,
but additionally the person-specific slope estimates used for "detrending" in \code{\link[feisr]{feis}}.
This allows to test whether we can omit the estimated values based on the slopes and reduce the model
to a conventional FE model. The Wald test of \code{type="art1"} is applied to the slope variables only.
\code{type="art2"} estimates the conventional regression-based Hausman test
\insertCite{@as described in @Wooldridge.2010.384, pp. 328-334}{feisr} comparing conventional
fixed effects models against random effects models.
\code{type="art3"} estimates a regression-based Hausman test comparing FEIS directly against RE,
thereby testing for inconsistency of the RE model due to either heterogeneous slopes or time-constant
omitted heterogeneity. For \code{art3} the Mundlak-specification includes only the person-specific
slopes, and no averages. This allows to test whether we can omit the estimated values based on
the slopes and reduce the model to a conventional RE model.
\insertCite{@for a formal description please see @Ruttenauer.2020}{feisr}.

Currently, the \code{tol} option in \code{feis()} is only forwarded in bsfeistest,
but not in feistest.



If specified (\code{robust=TRUE}), \code{feistest} uses panel-robust standard errors.
}
\examples{
data("mwp", package = "feisr")
feis.mod <- feis(lnw ~ marry + enrol | year,
                 data = mwp, id = "id", robust = TRUE)
ht <- feistest(feis.mod, robust = TRUE, type = "all")
summary(ht)
# Only for marry coefficient
ht2 <- feistest(feis.mod, robust = TRUE, type = "all", terms = c("marry"))
summary(ht2)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[feisr]{summary.feistest}}, \code{\link[feisr]{bsfeistest}},
\code{\link[feisr]{feis}},  \code{\link[plm]{plm}},
\code{\link[plm]{phtest}}
}
