% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc_package.R, R/fcuk-package.R
\docType{package}
\name{fcuk-package}
\alias{fcuk-package}
\alias{fcuk}
\title{fcuk: The Ultimate Helper for Clumsy Fingers}
\description{
Automatically suggests a correction when a typo occurs.

The fcuk package automatically suggests corrections when a typo occurs
in R code. It intercepts error messages and provides helpful suggestions
based on string distance algorithms.
}
\section{Main Features}{

\itemize{
  \item Automatic error interception and correction suggestions
  \item Support for multiple languages (English, French, German, Spanish, etc.)
  \item Quick rerun with `.+1` operator to apply suggested corrections
  \item Caching for improved performance
}
}

\section{Getting Started}{

The package is automatically activated when loaded with `library(fcuk)`.
When an error occurs, fcuk will suggest corrections. Use `.+1` to apply
the first suggestion, or `.+2` for the second.
}

\section{Functions}{

\itemize{
  \item [error_analysis()]: Analyse an error and suggest corrections
  \item [catch_error()]: Extract object name from error message
  \item [error_correction_propostion()]: Find closest matching names
  \item [get_all_objects_from_r()]: Get all available object names
  \item [init_error_tracker()]: Enable automatic error tracking
  \item [remove_error_tracker()]: Disable automatic error tracking
  \item [add_fcuk_to_rprofile()]: Add fcuk to your .Rprofile
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://thinkr-open.github.io/fcuk/}
  \item \url{https://github.com/ThinkR-open/fcuk}
  \item Report bugs at \url{https://github.com/ThinkR-open/fcuk/issues}
}


Useful links:
\itemize{
  \item \url{https://thinkr-open.github.io/fcuk/}
  \item \url{https://github.com/ThinkR-open/fcuk}
  \item Report bugs at \url{https://github.com/ThinkR-open/fcuk/issues}
}

}
\author{
\strong{Maintainer}: Vincent Guyader \email{vincent@thinkr.fr} (\href{https://orcid.org/0000-0003-0671-9270}{ORCID})

Other contributors:
\itemize{
  \item ThinkR [copyright holder]
}

}
\keyword{internal}
