% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{report.FASSTER}
\alias{report.FASSTER}
\title{Report on a FASSTER model}
\usage{
\method{report}{FASSTER}(object, ...)
}
\arguments{
\item{object}{A FASSTER model object.}

\item{...}{Additional arguments (currently unused).}
}
\value{
Invisibly returns NULL. Called for its side effect of printing the
variance report to the console.
}
\description{
Prints a detailed report of the estimated variance parameters for a FASSTER
model. This includes the state noise variances (W) for each model component
and the observation noise variance (V).
}
\details{
The report displays:
\itemize{
\item State noise variances (W): The variance of the random innovations
for each state component, grouped by model term.
\item Observation noise variance (V): The variance of the measurement error.
}
}
\examples{
library(tsibble)
fit <- as_tsibble(mdeaths) |>
  model(FASSTER(value ~ trend(1) + fourier(12)))

# Print variance report
report(fit)

}
