% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{refit.FASSTER}
\alias{refit.FASSTER}
\title{Refit a FASSTER model}
\usage{
\method{refit}{FASSTER}(object, new_data, specials = NULL, reestimate = FALSE, ...)
}
\arguments{
\item{object}{A fitted FASSTER model.}

\item{new_data}{A tsibble containing the new data.}

\item{specials}{(passed by \code{\link[fabletools:refit]{fabletools::refit.mdl_df()}}).}

\item{reestimate}{If \code{TRUE}, the model parameters will be re-estimated to suit
the new data using the heuristic approach. If \code{FALSE}, the existing model
structure and parameters are applied to the new data without modification.}

\item{...}{Additional arguments passed to the training function.}
}
\value{
A refitted FASSTER model.
}
\description{
Applies a fitted FASSTER model to a new dataset.
}
\examples{
library(tsibble)

# Fit model to male deaths
fit_male <- as_tsibble(mdeaths) |>
  model(FASSTER(value ~ trend(1) + fourier(12)))

# Refit to female deaths without re-estimating parameters
refit(fit_male, as_tsibble(fdeaths), reestimate = FALSE)

# Refit to female deaths with re-estimated parameters
refit(fit_male, as_tsibble(fdeaths), reestimate = TRUE)

}
