% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{glance.FASSTER}
\alias{glance.FASSTER}
\title{Glance at a FASSTER model}
\usage{
\method{glance}{FASSTER}(x, ...)
}
\arguments{
\item{x}{A FASSTER model object.}

\item{...}{Additional arguments (currently unused).}
}
\value{
A one-row tibble containing:
\describe{
\item{sigma2}{The estimated observation variance (V). If the model has
multivariate observations, this is a list containing the variance matrix.}
\item{log_lik}{The log-likelihood of the model.}
\item{AIC}{Akaike Information Criterion.}
\item{AICc}{Corrected AIC for small sample sizes.}
\item{BIC}{Bayesian Information Criterion.}
}
}
\description{
Constructs a single-row summary of the model's goodness-of-fit statistics.
This method follows the broom package conventions and is used by fabletools
to provide model selection metrics.
}
\examples{
library(tsibble)
fit <- as_tsibble(mdeaths) |>
  model(FASSTER(value ~ trend(1) + fourier(12)))

# Get model fit statistics
glance(fit)

}
