% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{map_factominer_legacy_names}
\alias{map_factominer_legacy_names}
\title{Map legacy FactoMineR category names to current labels}
\usage{
map_factominer_legacy_names(
  X,
  names,
  element = c("quali.var", "quali.sup", "var"),
  quiet = FALSE
)
}
\arguments{
\item{X}{a FactoMineR object (MCA, MFA, FAMD, HMFA).}

\item{names}{character vector of category labels.}

\item{element}{element to map. Use "var" for MCA categories or "quali.var"
for MFA/FAMD/HMFA qualitative categories. "quali.sup" maps supplementary
qualitative categories when available.}

\item{quiet}{if TRUE, suppress warnings.}
}
\value{
Character vector of mapped labels.
}
\description{
Map legacy FactoMineR category names to current labels
}
\examples{
\donttest{
if (requireNamespace("FactoMineR", quietly = TRUE)) {
  data(poison)
  res.mca <- FactoMineR::MCA(poison, quanti.sup = 1:2, quali.sup = 3:4, graph = FALSE)
  map <- factominer_category_map(res.mca, element = "var")
  map_factominer_legacy_names(res.mca, map$legacy_underscore[1:3], element = "var")
}
}
}
