% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fviz_ellipses.R
\name{fviz_ellipses}
\alias{fviz_ellipses}
\title{Draw confidence ellipses around the categories}
\usage{
fviz_ellipses(
  X,
  habillage,
  axes = c(1, 2),
  addEllipses = TRUE,
  ellipse.type = "confidence",
  palette = NULL,
  pointsize = 1,
  geom = c("point", "text"),
  ggtheme = theme_bw(),
  ...
)
}
\arguments{
\item{X}{an object of class MCA, PCA or MFA.}

\item{habillage}{a numeric vector of indexes of variables or a
character vector of names of variables. Can be also a data frame containing grouping variables.}

\item{axes}{a numeric vector specifying the axes of interest. Default values 
are 1:2 for axes 1 and 2.}

\item{addEllipses}{logical value. If TRUE, draws ellipses around the 
individuals when habillage != "none".}

\item{ellipse.type}{Character specifying frame type. Possible values are 
\code{"convex"}, \code{"confidence"} or types supported by 
\code{\link[ggplot2]{stat_ellipse}()} including one of \code{c("t", "norm", 
"euclid")} for plotting concentration ellipses.

\itemize{ \item \code{"convex"}: plot convex hull of a set of points. \item 
\code{"confidence"}: plot confidence ellipses around group mean points as
\code{\link[FactoMineR]{coord.ellipse}()}[in FactoMineR]. \item \code{"t"}:
assumes a multivariate t-distribution. \item \code{"norm"}: assumes a
multivariate normal distribution. \item \code{"euclid"}: draws a circle with
the radius equal to level, representing the euclidean distance from the
center. This ellipse probably won't appear circular unless
\code{\link[ggplot2]{coord_fixed}()} is applied.}}

\item{palette}{the color palette to be used for coloring or filling by
groups. Allowed values include "grey" for grey color palettes; brewer
palettes e.g. "RdBu", "Blues", ...; or custom color palette e.g. c("blue",
"red"); and scientific journal palettes from ggsci R package, e.g.: "npg",
"aaas", "lancet", "jco", "ucscgb", "uchicago", "simpsons" and
"rickandmorty". Can be also a numeric vector of length(groups); in this
case a basic color palette is created using the function
\link[grDevices]{palette}.}

\item{pointsize}{the size of points}

\item{geom}{a text specifying the geometry to be used for the graph.  Allowed
values are the combination of c("point", "text"). Use "point" (to show only
points); "text" to show only labels; c("point", "text") to show both types.}

\item{ggtheme}{function, ggplot2 theme name. Default value is theme_pubr().
Allowed values include ggplot2 official themes: theme_gray(), theme_bw(),
theme_minimal(), theme_classic(), theme_void(), ....}

\item{...}{Arguments to be passed to the functions ggpubr::ggscatter()  &
ggpubr::ggpar().}
}
\value{
a ggplot
}
\description{
Draw confidence ellipses around the categories
}
\examples{
\donttest{

# Multiple Correspondence Analysis
# +++++++++++++++++++++++++++++++++
library(FactoMineR)
data(poison)
res.mca <- MCA(poison, quanti.sup = 1:2, 
              quali.sup = 3:4, graph=FALSE)
              
fviz_ellipses(res.mca, 1:4, geom = "point",
palette = "jco") 

 }
}
\author{
Alboukadel Kassambara \email{alboukadel.kassambara@gmail.com}
}
