% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{factominer_category_map}
\alias{factominer_category_map}
\title{Map FactoMineR category labels to legacy naming patterns}
\usage{
factominer_category_map(X, element = c("quali.var", "quali.sup", "var"))
}
\arguments{
\item{X}{a FactoMineR object (MCA, MFA, FAMD, HMFA).}

\item{element}{element to map. Use "var" for MCA categories or "quali.var"
for MFA/FAMD/HMFA qualitative categories. "quali.sup" maps supplementary
qualitative categories when available.}
}
\value{
A data.frame with current labels, variable names, levels, and legacy
  naming patterns.
}
\description{
Map FactoMineR category labels to legacy naming patterns
}
\examples{
\donttest{
if (requireNamespace("FactoMineR", quietly = TRUE)) {
  data(poison)
  res.mca <- FactoMineR::MCA(poison, quanti.sup = 1:2, quali.sup = 3:4, graph = FALSE)
  head(factominer_category_map(res.mca, element = "var"))
}
}
}
