% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facto_summarize.R
\name{facto_summarize}
\alias{facto_summarize}
\title{Subset and summarize the output of factor analyses}
\usage{
facto_summarize(
  X,
  element,
  node.level = 1,
  group.names,
  result = c("coord", "cos2", "contrib"),
  axes = 1:2,
  select = NULL
)
}
\arguments{
\item{X}{an object of class PCA, CA, MCA, FAMD, MFA and HMFA [FactoMineR]; prcomp
and princomp [stats]; dudi, pca, coa and acm [ade4]; ca [ca package]; expoOutput [ExPosition].}

\item{element}{the element to subset from the output. Possible values are 
"row" or "col" for CA; "var" or "ind" for PCA and MCA; "mca.cor" for MCA; 
'quanti.var', 'quali.var' , 'group' or 'ind' for FAMD, MFA and HMFA.}

\item{node.level}{a single number indicating the HMFA node level.}

\item{group.names}{a vector containing the name of the groups (by default, 
NULL and the group are named group.1, group.2 and so on).}

\item{result}{the result to be extracted for the element. Possible values are
the combination of c("cos2", "contrib", "coord")}

\item{axes}{a numeric vector specifying the axes of interest. Default values 
are 1:2 for axes 1 and 2.}

\item{select}{a selection of variables. Allowed values are NULL or a list 
containing the arguments name, cos2 or contrib. Default is list(name = 
NULL, cos2 = NULL, contrib = NULL): \itemize{ \item name: is a character 
vector containing variable names to be selected \item cos2: if cos2 is in 
[0, 1], ex: 0.6, then variables with a cos2 > 0.6 are selected. if cos2 > 
1, ex: 5, then the top 5 variables with the highest cos2 are selected \item
contrib: if contrib > 1, ex: 5,  then the top 5 variables with the highest 
cos2 are selected. }}
}
\value{
A data frame containing the (total) coord, cos2 and the contribution 
  for the axes.
}
\description{
Subset and summarize the results of Principal Component Analysis
  (PCA), Correspondence Analysis (CA), Multiple Correspondence Analysis
  (MCA), Factor Analysis of Mixed Data (FAMD), Multiple Factor Analysis
  (MFA) and Hierarchical Multiple Factor Analysis (HMFA) functions from several packages.
}
\details{
If length(axes) > 1, then the columns contrib and cos2 correspond to
  the total contributions and total cos2 of the axes. In this case, the 
  column coord is calculated as x^2 + y^2 + ...+; x, y, ... are the 
  coordinates of the points on the specified axes.
}
\examples{
# Principal component analysis
# +++++++++++++++++++++++++++++
data(decathlon2)
decathlon2.active <- decathlon2[1:23, 1:10]
res.pca <- prcomp(decathlon2.active,  scale = TRUE)

# Summarize variables on axes 1:2
facto_summarize(res.pca, "var", axes = 1:2)[,-1]
# Select the top 5 contributing variables
facto_summarize(res.pca, "var", axes = 1:2,
           select = list(contrib = 5))[,-1]
# Select variables with cos2 >= 0.6
facto_summarize(res.pca, "var", axes = 1:2,
           select = list(cos2 = 0.6))[,-1]
# Select by names
facto_summarize(res.pca, "var", axes = 1:2,
     select = list(name = c("X100m", "Discus", "Javeline")))[,-1]
           
# Summarize individuals on axes 1:2
facto_summarize(res.pca, "ind", axes = 1:2)[,-1]

# Correspondence Analysis
# ++++++++++++++++++++++++++
# Install and load FactoMineR to compute CA
# install.packages("FactoMineR")
library("FactoMineR")
data("housetasks")
res.ca <- CA(housetasks, graph = FALSE)
# Summarize row variables on axes 1:2
facto_summarize(res.ca, "row", axes = 1:2)[,-1]
# Summarize column variables on axes 1:2
facto_summarize(res.ca, "col", axes = 1:2)[,-1]

# Multiple Correspondence Analysis
# +++++++++++++++++++++++++++++++++
library(FactoMineR)
data(poison)
res.mca <- MCA(poison, quanti.sup = 1:2, 
              quali.sup = 3:4, graph=FALSE)
# Summarize variables on axes 1:2
res <- facto_summarize(res.mca, "var", axes = 1:2)
head(res)
# Summarize individuals on axes 1:2
res <- facto_summarize(res.mca, "ind", axes = 1:2)
head(res)

# Multiple factor Analysis
# +++++++++++++++++++++++++++++++++
library(FactoMineR)
data(poison)
res.mfa <- MFA(poison, group=c(2,2,5,6), type=c("s","n","n","n"),
               name.group=c("desc","desc2","symptom","eat"),
               num.group.sup=1:2, graph=FALSE)
# Summarize categorcial variables on axes 1:2
res <- facto_summarize(res.mfa, "quali.var", axes = 1:2)
head(res)
# Summarize individuals on axes 1:2
res <- facto_summarize(res.mfa, "ind", axes = 1:2)
head(res)
}
\references{
\url{https://www.sthda.com/english/}
}
\author{
Alboukadel Kassambara \email{alboukadel.kassambara@gmail.com}
}
