% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{clean_lock_files}
\alias{clean_lock_files}
\title{Clean up stale package lock files}
\usage{
clean_lock_files(package = "factoextra", lib = .libPaths()[1], ask = TRUE)
}
\arguments{
\item{package}{Character string specifying which package lock to remove.
Default is "factoextra". Use "all" to remove all lock files.}

\item{lib}{Library path to check. Default is the first library in .libPaths().}

\item{ask}{Logical. If TRUE (default), asks for confirmation before removing.}
}
\value{
Invisibly returns TRUE if files were removed, FALSE otherwise.
}
\description{
Removes stale lock directories that can prevent package installation.

Lock files are created during package installation and should be automatically
removed when installation completes. If installation is interrupted (e.g., by
closing R or a crash), these lock files may remain and block future installations.
}
\examples{
\dontrun{
# Remove factoextra lock file
clean_lock_files()

# Remove all lock files
clean_lock_files("all")

# Remove without confirmation
clean_lock_files(ask = FALSE)
}
}
\keyword{internal}
