% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{aggregate_key}
\alias{aggregate_key}
\title{Expand a dataset to include other levels of aggregation}
\usage{
aggregate_key(.data, .spec, ...)
}
\arguments{
\item{.data}{A tsibble.}

\item{.spec}{The specification of aggregation structure.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Name-value pairs of
summary functions. The name will be the name of the variable in the result.

The value can be:
\itemize{
\item A vector of length 1, e.g. \code{min(x)}, \code{n()}, or \code{sum(is.na(y))}.
\item A data frame with 1 row, to add multiple columns from a single expression.
}}
}
\description{
Uses the structural specification given in \code{.spec} to aggregate a time
series. A grouped structure is specified using \code{grp1 * grp2}, and a nested
structure is specified via \code{parent / child}. Aggregating the key structure is
commonly used with forecast reconciliation to produce coherent forecasts over
some hierarchy.
}
\details{
This function is experimental, and is subject to change in the future.

The way in which the measured variables are aggregated is specified in a
similar way to how \verb{[dplyr::summarise()]} is used.
}
\examples{
library(tsibble)
tourism \%>\% 
  aggregate_key(Purpose * (State / Region), Trips = sum(Trips))

}
\seealso{
\code{\link[=reconcile]{reconcile()}}, \code{\link[=is_aggregated]{is_aggregated()}}
}
