% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preview_palette.R
\name{preview_palette}
\alias{preview_palette}
\title{Preview Palette: Visualize a Palette from RDS}
\usage{
preview_palette(
  name,
  type = c("sequential", "diverging", "qualitative"),
  n = NULL,
  plot_type = c("bar", "pie", "point", "rect", "circle"),
  title = name,
  palette_rds = system.file("extdata", "palettes.rds", package = "evanverse"),
  preview = TRUE
)
}
\arguments{
\item{name}{Name of the palette.}

\item{type}{Palette type: "sequential", "diverging", "qualitative".}

\item{n}{Number of colors to use (default: all).}

\item{plot_type}{Plot style: "bar", "pie", "point", "rect", "circle".}

\item{title}{Plot title (default: same as palette name).}

\item{palette_rds}{Path to RDS file. Default: system.file("extdata", "palettes.rds", package = "evanverse").}

\item{preview}{Whether to show the plot immediately. Default: TRUE.}
}
\value{
NULL (invisible), for plotting side effect.
}
\description{
Preview the appearance of a palette from \code{data/palettes.rds} using various plot types.
This function provides multiple visualization options to help users evaluate color palettes.
}
\examples{
\donttest{
# Preview sequential palette:
preview_palette("seq_blues", type = "sequential", plot_type = "bar")

# Preview diverging palette:
preview_palette("div_fireice", type = "diverging", plot_type = "pie")

# Preview qualitative palette with custom colors:
preview_palette("qual_vivid", type = "qualitative", n = 4, plot_type = "circle")
}
}
