% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg.R
\name{pkg_version}
\alias{pkg_version}
\title{Check Package Versions}
\usage{
pkg_version(pkg, preview = TRUE)
}
\arguments{
\item{pkg}{Character vector. Package names to check.}

\item{preview}{Logical. If TRUE (default), print result to console.}
}
\value{
A data.frame with columns: \code{package}, \code{version} (installed),
\code{latest} (available), and \code{source}.
}
\description{
Check installed and latest available versions of R packages across
CRAN, Bioconductor, and GitHub. Supports case-insensitive matching.
}
\examples{
\dontrun{
# Check versions of multiple packages:
pkg_version(c("ggplot2", "dplyr"))

# Check without console preview:
result <- pkg_version(c("ggplot2", "limma"), preview = FALSE)
}

}
