% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erviss_sari_positivity.R
\name{quick_plot_sari_positivity}
\alias{quick_plot_sari_positivity}
\title{Quick plot of ERVISS SARI positivity data}
\usage{
quick_plot_sari_positivity(
  csv_file = NULL,
  date_min,
  date_max,
  pathogen = "",
  indicator = "",
  age = "",
  countries = "",
  date_breaks = "2 weeks",
  date_format = "\%b \%Y",
  use_snapshot = FALSE,
  snapshot_date = NULL
)
}
\arguments{
\item{csv_file}{Path to a local CSV file or URL containing the ERVISS data.
If NULL (default), data is fetched from the official ERVISS repository.}

\item{date_min}{Start date of the period (Date object)}

\item{date_max}{End date of the period (Date object)}

\item{pathogen}{Character vector of pathogen names to filter.
Use "" (default) to include all pathogens.}

\item{indicator}{Character vector of indicators to filter:
"positivity", "detections", "tests", or any combination.
Use "" (default) to include all indicators.}

\item{age}{Character vector of age groups to filter (e.g., "total", "0-4",
"5-14", "15-64", "65+").
Use "" (default) to include all age groups.}

\item{countries}{Character vector of country names to filter.
Use "" (default) to include all countries.}

\item{date_breaks}{A string specifying the date breaks for the x-axis
(e.g., "1 month", "2 weeks")}

\item{date_format}{A string specifying the date format for x-axis labels
(e.g., \code{"\%b \%Y"} for "Jan 2024")}

\item{use_snapshot}{Logical. If TRUE, fetches a historical snapshot; if FALSE (default),
fetches the latest data. Ignored if csv_file is provided.}

\item{snapshot_date}{Date of the snapshot to retrieve.
Required if use_snapshot = TRUE and csv_file is NULL.}
}
\value{
A ggplot2 object showing SARI positivity over time by country
and pathogen
}
\description{
Convenience function that fetches and plots ERVISS SARI positivity data
in one step.
For more control, use \code{\link{get_sari_positivity}} followed by
\code{\link{plot_sari_positivity}}.
}
\examples{
\donttest{
# Quick visualization of SARI positivity
quick_plot_sari_positivity(
  date_min = as.Date("2024-01-01"),
  date_max = as.Date("2024-12-31"),
  pathogen = "Influenza",
  indicator = "positivity",
  date_breaks = "1 month"
)
}
}
