% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erviss_nonsentinel_tests.R
\name{quick_plot_nonsentinel_tests}
\alias{quick_plot_nonsentinel_tests}
\title{Quick plot of ERVISS non-sentinel tests/detections data}
\usage{
quick_plot_nonsentinel_tests(
  csv_file = NULL,
  date_min,
  date_max,
  pathogen = "",
  indicator = "",
  age = "",
  countries = "",
  date_breaks = "1 month",
  date_format = "\%b \%Y",
  use_snapshot = FALSE,
  snapshot_date = NULL
)
}
\arguments{
\item{csv_file}{Path to a local CSV file or URL containing the ERVISS data.
If NULL (default), data is fetched from the official ERVISS repository.}

\item{date_min}{Start date of the period (Date object)}

\item{date_max}{End date of the period (Date object)}

\item{pathogen}{Character vector of pathogen names to filter.
Use "" (default) to include all pathogens.}

\item{indicator}{Character vector of indicators to filter:
"detections", "tests", or both.
Use "" (default) to include all indicators.}

\item{age}{Character vector of age groups to filter (e.g., "total").
Use "" (default) to include all age groups.}

\item{countries}{Character vector of country names to filter.
Use "" (default) to include all countries.}

\item{date_breaks}{A string specifying the date breaks for the x-axis
(e.g., "1 month", "2 weeks")}

\item{date_format}{A string specifying the date format for x-axis labels
(e.g., \code{"\%b \%Y"} for "Jan 2024")}

\item{use_snapshot}{Logical. If TRUE, fetches a historical snapshot; if FALSE (default),
fetches the latest data. Ignored if csv_file is provided.}

\item{snapshot_date}{Date of the snapshot to retrieve.
Required if use_snapshot = TRUE and csv_file is NULL.}
}
\value{
A ggplot2 object showing non-sentinel tests/detections over time
by country and pathogen
}
\description{
Convenience function that fetches and plots ERVISS non-sentinel tests/detections
data in one step.
For more control, use \code{\link{get_nonsentinel_tests}} followed by
\code{\link{plot_nonsentinel_tests}}.
}
\examples{
\donttest{
# Quick visualization of non-sentinel detections
quick_plot_nonsentinel_tests(
  date_min = as.Date("2024-01-01"),
  date_max = as.Date("2024-12-31"),
  pathogen = "Influenza",
  indicator = "detections",
  date_breaks = "1 month"
)
}
}
