% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erviss_positivity.R
\name{plot_erviss_positivity}
\alias{plot_erviss_positivity}
\title{Plot ERVISS positivity data}
\usage{
plot_erviss_positivity(data, date_breaks = "2 weeks", date_format = "\%b \%Y")
}
\arguments{
\item{data}{A data.table or data.frame containing positivity data, typically output from
\code{\link{get_sentineltests_positivity}}. Must contain columns: date, value,
pathogen, countryname.}

\item{date_breaks}{A string specifying the date breaks for the x-axis
(e.g., "1 month", "2 weeks")}

\item{date_format}{A string specifying the date format for x-axis labels
(e.g., \code{"\%b \%Y"} for "Jan 2024")}
}
\value{
A ggplot2 object
}
\description{
Creates a ggplot2 visualization of positivity data, with facets by country
and colored by pathogen. The plot title displays mean, min and max positivity values.
}
\examples{
\donttest{
data <- get_sentineltests_positivity(
  date_min = as.Date("2024-01-01"),
  date_max = as.Date("2024-06-30"),
  pathogen = "SARS-CoV-2"
)
plot_erviss_positivity(data, date_breaks = "1 month")
}
}
