% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.bipartite.R
\name{b2nodematch-ergmTerm}
\alias{b2nodematch-ergmTerm}
\alias{InitErgmTerm.b2nodematch}
\title{Nodal attribute-based homophily effect for the second mode in a bipartite network}
\usage{
# binary: b2nodematch(attr, diff=FALSE, keep=NULL, alpha=1, beta=1, byb1attr=NULL,
#                     levels=NULL)
}
\arguments{
\item{diff}{by default, one statistic will be added to the model. If \code{diff} is set to \code{TRUE}, one statistic will be added for each unique value of the \code{attr} attribute}

\item{keep}{deprecated}

\item{alpha, beta}{optional discount parameters both of which take values from \verb{[0, 1]}, only one should be
set at one time}

\item{byb2attr}{specifies a
second mode categorical attribute. Setting this argument
will separate the orginal statistics based on the values of the set second mode attribute---
i.e. for example, if \code{diff} is \code{FALSE} , then the sum of all the statistics for
each level of this second-mode attribute will be equal to the original \code{b1nodematch}
statistic where \code{byb2attr} set to \code{NULL} .}

\item{levels}{select a subset of \code{attr} values to include. (See Specifying Vertex
attributes and Levels (\code{\link[=nodal_attributes]{?nodal_attributes}}) for details.)}

\item{attr}{a vertex attribute specification (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.)}
}
\description{
This term is introduced by \insertCite{BoBa23m;textual}{ergm}.
With the default \code{alpha} and \code{beta} values, this term will
simply be a homophily based two-star statistic. This term adds one statistic to the model
unless \code{diff} is set to \code{TRUE} , in which case the term adds multiple network
statistics to the model, one for each of (a subset of) the unique values of the \code{attr}
attribute.
}
\details{
If an \code{alpha}
discount parameter is used, each of these statistics gives the sum of
the number of common first-mode nodes raised to the power \code{alpha} for each pair of
second-mode nodes with that attribute. If a \code{beta} discount parameter is used, each
of these statistics gives half the sum of the number of two-paths with two second-mode nodes
with that attribute as the two ends of the two path raised to the power \code{beta} for each
edge in the network.
}
\note{
This term can only be used with undirected bipartite networks.

The argument \code{keep} is retained for backwards compatibility and may be
removed in a future version. When both \code{keep} and \code{levels} are passed,
\code{levels} overrides \code{keep}. See \code{\link{nodal_attributes}}.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "b2nodematch", "subsection")}
}
\concept{bipartite}
\concept{categorical nodal attribute}
\concept{dyad-independent}
\concept{frequently-used}
\concept{undirected}
