% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{abc_calibration_params}
\alias{abc_calibration_params}
\title{ABC calibration results for COVID-19 SIR model}
\format{
A named list with the following elements:
\describe{
\item{contact_rate}{Posterior median of the contact rate.}
\item{recovery_rate}{Posterior median of the recovery rate.}
\item{transmission_prob}{Posterior median of the transmission probability.}
\item{R0}{Basic reproduction number computed from posterior medians.}
\item{contact_rate_ci}{95 percent credible interval for the contact rate.}
\item{recovery_rate_ci}{95 percent credible interval for the recovery rate.}
\item{transmission_prob_ci}{95 percent credible interval for the transmission probability.}
\item{calibration_time_seconds}{Total runtime of the ABC calibration (seconds).}
\item{n_samples}{Number of MCMC samples used in calibration.}
\item{burnin}{Number of burn-in iterations discarded.}
\item{epsilon}{ABC tolerance parameter.}
\item{seed}{Random seed used for reproducibility.}
\item{posterior_samples}{Matrix of post-burn-in accepted parameter samples.}
\item{acceptance_rate}{Acceptance rate of the ABC-MCMC algorithm (percent).}
}
}
\source{
Generated internally using the script
\code{data-raw/process_covid_calibration.R}.
}
\usage{
abc_calibration_params
}
\description{
Results from Approximate Bayesian Computation (ABC) calibration of an
SIR network model fitted to Utah COVID-19 incidence data.
}
\examples{
data("abc_calibration_params")
str(abc_calibration_params)

}
\keyword{datasets}
