% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{pvt_norostat}
\alias{pvt_norostat}
\title{CDC NoroSTAT norovirus outbreaks}
\usage{
pvt_norostat(auth, locations, epiweeks = "*", fetch_args = fetch_args_list())
}
\arguments{
\item{auth}{string. Your authentication key.}

\item{locations}{character. Locations to fetch.}

\item{epiweeks}{\code{\link{timeset}}. Epiweeks to fetch. Defaults to all ("*") dates.}

\item{fetch_args}{\code{\link{fetch_args}}. Additional arguments to pass to \code{fetch()}.}
}
\value{
\code{\link[tibble:tibble]{tibble::tibble}}
}
\description{
This is point data only, and does not include minima or maxima.

API docs: \url{https://cmu-delphi.github.io/delphi-epidata/api/norostat.html}

This is the documentation of the API for accessing the NoroSTAT endpoint of
the Delphi’s epidemiological data.
}
\examples{
\dontrun{
pvt_norostat(
  auth = Sys.getenv("SECRET_API_AUTH_NOROSTAT"),
  locations = "Minnesota, Ohio, Oregon, Tennessee, and Wisconsin",
  epiweeks = 201233
)
}
}
\keyword{endpoint}
