% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmonize_brackets.R
\name{get_income_brackets}
\alias{get_income_brackets}
\title{Get Available Income Brackets for a Dataset and Vintage}
\usage{
get_income_brackets(dataset, vintage)
}
\arguments{
\item{dataset}{Character, either "ami" or "fpl"}

\item{vintage}{Integer, the year of the data vintage (e.g., 2018, 2022)}
}
\value{
Character vector of income bracket names
}
\description{
Returns the expected income brackets for a given dataset and vintage year.
Useful for understanding what brackets are available before running analyses.
}
\examples{
# Get AMI brackets for 2022
get_income_brackets("ami", 2022)

# Get FPL brackets for 2018
get_income_brackets("fpl", 2018)

}
