% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TRN_MHmcmc_p.R
\name{TRN_MHmcmc_p}
\alias{TRN_MHmcmc_p}
\title{Generates set of parameters to be used with GRTRN_MHmcmc() or STRN_MHmcmc()}
\usage{
TRN_MHmcmc_p(
  result = NULL,
  parameters = NULL,
  fixed.parameters = NULL,
  accept = FALSE
)
}
\arguments{
\item{result}{An object obtained after a SearchR fit}

\item{parameters}{A set of parameters. Replace the one from result}

\item{fixed.parameters}{A set of fixed parameters. Replace the one from result}

\item{accept}{If TRUE, the script does not wait user information}
}
\value{
A matrix with the parameters
}
\description{
Interactive script used to generate set of parameters to be used with GRTRN_MHmcmc() or STRN_MHmcmc().\cr
}
\details{
TRN_MHmcmc_p generates set of parameters to be used with GRTRN_MHmcmc() or STRN_MHmcmc()
}
\examples{
\dontrun{
library(embryogrowth)
data(nest)
formated <- FormatNests(nest)
# The initial parameters value can be:
# "T12H", "DHA",  "DHH", "Rho25"
# Or
# "T12L", "T12H", "DHA",  "DHH", "DHL", "Rho25"
############################################################################
pfixed <- c(rK=1.208968)
M0 = 0.3470893 
############################################################################
# 4 parameters
############################################################################
x <- structure(c(105.966881676793, 613.944134764125, 306.449533440186, 
                118.193882815108), .Names = c("DHA", "DHH", "T12H", "Rho25"))
resultNest_4p_SSM <- searchR(parameters=x, fixed.parameters=pfixed, 
	temperatures=formated, integral=integral.Gompertz, M0=M0, 
	hatchling.metric=c(Mean=39.33, SD=1.92))
data(resultNest_4p_SSM)
plot(resultNest_4p_SSM, xlim=c(0,70), ylimT=c(22, 32), ylimS=c(0,45), series=1, 
embryo.stages="Caretta caretta.SCL")
############################################################################
pMCMC <- TRN_MHmcmc_p(resultNest_4p_SSM, accept=TRUE)
}
}
\author{
Marc Girondot
}
