% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{vd_dem_vdm_screen}
\alias{vd_dem_vdm_screen}
\title{Demand Prediction (Volumetric demand, attribute-based screening)}
\usage{
vd_dem_vdm_screen(vd, est, epsilon_not = NULL, error_dist = NULL, cores = NULL)
}
\arguments{
\item{vd}{data}

\item{est}{ec-model draws}

\item{epsilon_not}{(optional) error realizations}

\item{error_dist}{(optional) A string defining the error term distribution (default: 'EV1')}

\item{cores}{(optional) cores}
}
\value{
Draws of expected demand
}
\description{
Generating demand predictions for volumetric demand model with attribute-based screening.
Reminder: there is no closed-form solution for demand, thus we need to integrate not only over the posterior distribution of parameters and the error distribution.
The function outputs a tibble containing id, task, alt, p, attributes, draws from the posterior of demand.
Eerror realisations can be pre-supplied to the \code{epsilon_not}. This helps create smooth demand curves or conduct optimization.
}
\examples{
data(icecream)
#run MCMC sampler (use way more than 20 draws for actual use)
icecream_est <- icecream \%>\% dplyr::filter(id<20) \%>\% vd_est_vdm_screen(R=20, keep=1, cores=2)
#Generate demand predictions
icecream_predicted_demand=
 icecream \%>\% dplyr::filter(id<20) \%>\%   
   vd_dem_vdm_screen(icecream_est, cores=2)
#column .demdraws contains draws from posterior of predicted demand
}
\seealso{
\code{\link[=prep_newprediction]{prep_newprediction()}} to match \code{vd}'s factor levels,
\code{\link[=ec_gen_err_normal]{ec_gen_err_normal()}} for pre-generating error realizations and
\code{\link[=vd_est_vdm_screen]{vd_est_vdm_screen()}} for estimating the corresponding model
}
