% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugins.R
\name{e_violin}
\alias{e_violin}
\title{Violin chart}
\usage{
e_violin(
  e,
  name = "violin",
  legend = TRUE,
  y_index = 0,
  x_index = 0,
  symbolSize = 10,
  areaOpacity = 0.5,
  binCount = 100,
  bandWidthScale = 1,
  ...
)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{name}{name of the serie.}

\item{legend}{Whether to add serie to legend.}

\item{x_index, y_index}{Indexes of x and y axis.}

\item{symbolSize}{overall size of symbol.}

\item{areaOpacity}{opacity of violin area.}

\item{binCount}{number of bins for violin plot. More bins will provide a more detailed version of the plot,}

\item{bandWidthScale}{scale for the amplitude of violin area}

\item{...}{additional options}
}
\description{
Draw a violin chart with scattered dots.
}
\examples{

PlantGrowth |>
  e_charts(group) |>
  e_scatter(weight) |>
  e_violin(binCount = 200)

}
\seealso{
\href{https://github.com/apache/echarts-custom-series/tree/main/custom-series/violin}{official documentation}
}
