% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{e_format_matrix_axis}
\alias{e_format_matrix_axis}
\title{Format Matrix Axis}
\usage{
e_format_matrix_axis(e, axis = "x", ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{axis}{indicate which axis shoud be adjusted}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
helper function for formatting the x and y axes for a matrix grid.
}
\examples{

df <- data.frame("Class" = rep(c("Class1", "Class2", "Class3"),each = 3),
"Grade" = c("Grade1","Grade2", "Grade3"),
"A" = sample(1:10, 9),
"B" = sample(1:10,9))

df |> e_charts() |> e_matrix(xAxis = "Class", yAxis = "Grade") |>
e_format_matrix_axis(axis = "x", label = list(color = "red"))

}
\seealso{
\href{https://echarts.apache.org/en/option.html#matrix}{Additional arguments}
}
