% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abc_resample.R
\name{abc_resample}
\alias{abc_resample}
\title{ABC with resampling}
\usage{
abc_resample(
  target,
  param,
  sumstat,
  n_iterations,
  n_samples,
  replace = FALSE,
  ...
)
}
\arguments{
\item{target}{Target summary statistics from observed data}

\item{param}{Parameter values matrix or data frame}

\item{sumstat}{Summary statistics matrix or data frame}

\item{n_iterations}{Number of resample iterations}

\item{n_samples}{Number of samples to draw in each iteration}

\item{replace}{Logical, whether to sample with replacement (default FALSE)}

\item{...}{Additional arguments passed to abc::abc}
}
\value{
A list of length \code{n_iterations}, where each element is an object
  of class \code{abc} returned by \code{\link[abc]{abc}}. Each list element
  contains the ABC posterior for one bootstrap iteration, allowing assessment
  of stability and uncertainty in parameter estimates.
}
\description{
Performs ABC inference with resampling to assess stability and uncertainty.
Each iteration draws a random sample from the simulation pool and runs ABC,
producing multiple posterior estimates for comparison.
}
\examples{
# Load ABC input data from example simulation
abc_input <- readRDS(
  system.file("extdata", "rdm_minimal", "abc", "abc_input.rds", package = "eam")
)

# Perform ABC resampling
results <- abc_resample(
  target = abc_input$target,
  param = abc_input$param,
  sumstat = abc_input$sumstat,
  n_iterations = 2,
  n_samples = 2,
  tol = 0.5,
  method = "rejection"
)

# check the abc results
str(results)
}
