% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train_tree.R
\name{train_rf}
\alias{train_rf}
\title{Fit a Conditional Random Forest}
\usage{
train_rf(
  data_train,
  target_lab,
  task = c("classification", "regression"),
  ntree = 500L,
  mtry = NULL,
  control = NULL
)
}
\arguments{
\item{data_train}{Data frame. Training data.}

\item{target_lab}{Character. Name of the target column.}

\item{task}{Character. \code{"classification"} or \code{"regression"}.}

\item{ntree}{Integer. Number of trees (default 500).}

\item{mtry}{Integer or NULL. Number of variables randomly sampled at each
split. If NULL, uses the \code{cforest} default.}

\item{control}{A \code{ctree_control} object or NULL.}
}
\value{
A list with elements:
\item{forest}{The fitted \code{cforest} object.}
\item{var_imp}{A named numeric vector of relative variable importance
(scaled to sum to 1 and rounded to two decimals).}
\item{ntree}{Integer. Number of trees in the forest.}
}
\description{
Fits a conditional random forest using \code{partykit::cforest()} and
returns the forest object along with variable importance scores.
}
\examples{
\donttest{
data(train_covid)
rf_res <- train_rf(train_covid, target_lab = "Outcome", ntree = 50)
rf_res$var_imp
}
}
