% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_tree.R
\name{prepare_tree}
\alias{prepare_tree}
\title{Prepare Tree Plot Data for Visualization}
\usage{
prepare_tree(tree_res, model = c("rpart", "party", "C50", "caret", "cforest"))
}
\arguments{
\item{tree_res}{A list object containing tree plotting information, including a \code{plot_data} data frame.}

\item{model}{A string indicating the tree model used. Options are \code{"rpart"}, \code{"party"}, \code{"C50"}, or \code{"caret"}.}
}
\value{
A list with two elements:
\describe{
\item{plot_data}{A data frame of node-level information with labels for visualization.}
\item{branches}{A data frame of edge (branch) coordinates for connecting parent and child nodes.}
}
}
\description{
This function processes a tree model's output and prepares node and segment data
for visualization using \code{ggplot2} or other plotting tools. It supports various tree
model formats such as \code{rpart}, \code{party}, \code{C50}, and \code{caret}.
}
\examples{
\donttest{
library(rpart)
library(partykit)
library(ggparty)
library(dplyr)
library(seriation)
data_all <- add_data_type(
  data_train = train_covid, data_test = test_covid
)
data <- prepare_features(
  data_all,
  target_lab = "Outcome",
  task = "classification"
)
train_tree <- train_tree(
  data_train = train_covid,
  target_lab = "Outcome", model = "rpart"
)
fit <- train_tree$fit
var_imp <- train_tree$var_imp
tree_res <- compute_tree(
  fit,
  model = "rpart", show = "test",
  data = data, target_lab = "Outcome",
  task = "classification"
)
prepare_tree(tree_res, model = "rpart")
}
}
