% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_ht.R
\name{make_main_heatmap}
\alias{make_main_heatmap}
\title{Draw Main Heatmap with Annotations}
\usage{
make_main_heatmap(
  sorted_dat,
  split_vec,
  pred_ha,
  row_prop_ha,
  layout,
  palette = "Blues",
  n_colors = 9,
  show_row_names = TRUE,
  row_names_gp = gpar(fontsize = 5),
  show_row_prox = TRUE,
  raw_value_col = NULL
)
}
\arguments{
\item{sorted_dat}{List from \code{sorted_mat()}, containing \code{sorted_test_matrix}.}

\item{split_vec}{Factor defining row splits in the heatmap.}

\item{pred_ha}{A \code{rowAnnotation} for predictions (from \code{prediction_annotation}).}

\item{row_prop_ha}{A \code{rowAnnotation} for row proximity (from \code{row_prop_anno}).}

\item{layout}{List with \code{row_h} and \code{col_h} in mm.}

\item{palette}{RColorBrewer palette for heatmap values (default "Blues").}

\item{n_colors}{Number of colors for heatmap (default 9).}

\item{show_row_names}{Logical. Whether to display row names in the heatmap (default TRUE).}

\item{row_names_gp}{\code{gpar} settings for row name font (default fontsize=5).}

\item{show_row_prox}{Logical, whether to show the right annotation for row proximity.}

\item{raw_value_col}{User-defined colors for raw data values.}
}
\value{
A configured \code{Heatmap} object.
}
\description{
Combines sorted data matrix and provided annotations into a single Heatmap.
}
\keyword{internal}
