% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtGAP.R
\name{dtGAP}
\alias{dtGAP}
\title{Decision Tree Generalized Association Plots (dtGAP)}
\usage{
dtGAP(
  x = NULL,
  target_lab = NULL,
  show = c("all", "train", "test"),
  model = c("rpart", "party", "C50", "caret"),
  control = NULL,
  fit = NULL,
  user_var_imp = NULL,
  data_train = NULL,
  data_test = NULL,
  data_all = NULL,
  test_size = 0.3,
  task = c("classification", "regression"),
  trans_type = c("normalize", "scale", "percentize", "none"),
  col_proximity = c("pearson", "spearman", "kendall"),
  linkage_method = c("CT", "SG", "CP"),
  seriate_method = "TSP",
  cRGAR_w = 5,
  select_vars = NULL,
  sort_by_data_type = TRUE,
  custom_layout = NULL,
  panel_space = 0.001,
  margin = 20,
  total_w = 297,
  total_h = 210,
  tree_p = 0.3,
  include_var_imp = TRUE,
  col_var_imp = "orange",
  var_imp_bar_width = 0.8,
  var_imp_fontsize = 5,
  split_var_bg = "darkgreen",
  split_var_fontsize = 5,
  Col_Prox_palette = "RdBu",
  Col_Prox_n_colors = 11,
  label_map = NULL,
  label_map_colors = NULL,
  type_palette = "Dark2",
  label_palette = "OrRd",
  n_label_color = 9,
  pred_ha_gap = unit(1, "mm"),
  prop_palette = gray,
  n_prop_colors = 11,
  Row_Prox_palette = "Spectral",
  Row_Prox_n_colors = 11,
  row_border = TRUE,
  row_gap = unit(1, "mm"),
  sorted_dat_palette = "Blues",
  sorted_dat_n_colors = 9,
  show_row_names = TRUE,
  row_names_gp = gpar(fontsize = 5),
  show_row_prox = TRUE,
  show_col_prox = TRUE,
  raw_value_col = NULL,
  lgd_direction = c("vertical", "horizontal"),
  x_eval_start = 15,
  y_eval_start = NULL,
  eval_text = 7,
  print_eval = TRUE,
  simple_metrics = FALSE,
  interactive = FALSE
)
}
\arguments{
\item{x}{Character. Name or label of the dataset.}

\item{target_lab}{Character. Name of the target column. Required.}

\item{show}{Character. Which subset to return: "all", "train" or "test" .}

\item{model}{Character. Which implementation to use: one of "rpart", "party", "C50", or "caret".
Ignored when \code{fit} is provided.}

\item{control}{List or control object. Optional control parameters passed to the chosen tree function.
Ignored when \code{fit} is provided.}

\item{fit}{Optional pre-built tree model object. Supported classes: \code{party},
\code{rpart}, \code{C5.0}, or \code{train} (caret). When supplied, \code{model}
and \code{control} are ignored; the model type is auto-detected.}

\item{user_var_imp}{Optional named numeric vector of variable importance scores.
Only used when \code{fit} is provided. If NULL, importance is extracted
automatically (or the importance barplot is suppressed if extraction fails).}

\item{data_train}{Data frame. Training data. Required if show == "train" or when splitting from all.}

\item{data_test}{Data frame. Test data. Required if show == "test" or when splitting from all.}

\item{data_all}{Data frame. Full dataset. If provided and show == "all", used directly; otherwise split into train/test.}

\item{test_size}{Numeric. Proportion of data to assign to testing set when splitting data_all (default 0.3).}

\item{task}{Character. Type of task: "classification" or "regression".}

\item{trans_type}{Character. One of "percentize","normalize","scale","none" passed to scale_norm().}

\item{col_proximity}{Character. Correlation method: "pearson","spearman","kendall".}

\item{linkage_method}{Character. Linkage for supervised distance: "CT","SG","CP".}

\item{seriate_method}{Character. Seriation method for distance objects; see
\code{seriation::list_seriation_methods("dist")} for all supported options. Default: \code{"TSP"}.}

\item{cRGAR_w}{Integer. Window size for RGAR calculation.}

\item{select_vars}{Character vector or NULL. If provided, only these variables
are displayed in the heatmap panels. The tree is always fit on ALL variables;
this parameter is display-only. Names must match feature column names.}

\item{sort_by_data_type}{Logical. If TRUE, preserves data_type grouping within nodes.}

\item{custom_layout}{Optional data.frame with custom node positions (columns: id, x, y).}

\item{panel_space}{Numeric. Vertical spacing between panels in layout.}

\item{margin}{Numeric. Margin around the drawing area (mm).}

\item{total_w}{Numeric. Total width of page (mm).}

\item{total_h}{Numeric. Total height of page (mm).}

\item{tree_p}{Numeric. Proportion of total width allocated to the tree panel.}

\item{include_var_imp}{Logical; include importance barplot if TRUE (default TRUE).}

\item{col_var_imp}{Color for importance bars (default "orange").}

\item{var_imp_bar_width}{Numeric width of bars (default 0.8).}

\item{var_imp_fontsize}{Font size for importance text (default 5).}

\item{split_var_bg}{Background color for split variable names (default "darkgreen").}

\item{split_var_fontsize}{Font size for split variable names (default 5).}

\item{Col_Prox_palette}{RColorBrewer palette for correlation heatmap (default "RdBu").}

\item{Col_Prox_n_colors}{Number of colors in correlation scale (default 11).}

\item{label_map}{Optional named vector to map raw labels to new labels.}

\item{label_map_colors}{Optional named vector of colors for mapped labels.}

\item{type_palette}{RColorBrewer palette for data_type (default "Dark2").}

\item{label_palette}{Function or vector of colors for true and predicted value (default OrRd).}

\item{n_label_color}{Number of colors for label palette (default 9).}

\item{pred_ha_gap}{Unit for gap between annotations (default \code{unit(1, "mm")} ).}

\item{prop_palette}{Function or vector of colors for probability gradient (default gray).}

\item{n_prop_colors}{Number of colors for probability palette (default 11).}

\item{Row_Prox_palette}{RColorBrewer palette name for row proximity color scale (default "Spectral").}

\item{Row_Prox_n_colors}{Number of discrete colors for row proximity (default 11).}

\item{row_border}{Logical; draw cell borders if TRUE (default TRUE).}

\item{row_gap}{Unit object for gap between annotation blocks (default \code{unit(1, "mm")} ).}

\item{sorted_dat_palette}{RColorBrewer palette for heatmap values (default "Blues").}

\item{sorted_dat_n_colors}{Number of colors for heatmap (default 9).}

\item{show_row_names}{Logical. Whether to display row names in the heatmap (default TRUE).}

\item{row_names_gp}{\code{gpar} settings for row name font (default fontsize=5).}

\item{show_row_prox}{Logical, whether to show row proximity.}

\item{show_col_prox}{Logical, whether to show column proximity.}

\item{raw_value_col}{User-defined colors for raw data values.}

\item{lgd_direction}{Character. Layout direction of packed legends, either "vertical" or "horizontal".}

\item{x_eval_start}{X-axis starting position (in mm) for evaluation text. Default is 15.}

\item{y_eval_start}{Y-axis starting position (in mm) for evaluation text. If NULL, it will be computed automatically.}

\item{eval_text}{Font size for the evaluation text. Default is 7.}

\item{print_eval}{Logical, whether to show evaluation results. Default is TRUE.}

\item{simple_metrics}{Logical. If TRUE, use simple metric summary instead of full confusion matrix. Default is FALSE.}

\item{interactive}{Logical. If TRUE, launches an interactive Shiny app via
\code{InteractiveComplexHeatmap::htShiny()} showing the heatmap panels with
hover/click/zoom. The tree panel is omitted in interactive mode (limitation
of InteractiveComplexHeatmap). Requires the \pkg{InteractiveComplexHeatmap}
package (from Bioconductor). Default is FALSE.}
}
\value{
Draws the full dtGAP visualization (decision tree + heatmap + evaluation)
to the current graphics device. Called for its side effect; returns invisibly.
}
\description{
The \code{dtGAP} function enhances decision tree visualization by incorporating the strengths of Generalized Association Plots (GAP).
While decision trees are valued for their interpretability, they often overlook deeper data structures. In contrast, GAP is effective for revealing complex associations but is typically limited to unsupervised settings.
dtGAP bridges this gap by introducing matrix-based visualizations—such as the confusion matrix map, decision tree matrix map, and predicted class membership map—based on supervised correlation and distance metrics.
This offers a more comprehensive and interpretable representation of decision-making processes in tree-based models.
}
\examples{
\donttest{
# Case 1: test_covid
dtGAP(
  data_train = train_covid,
  data_test = test_covid,
  target_lab = "Outcome", show = "test",
  label_map = c("0" = "Survival", "1" = "Death"),
  label_map_colors = c(
    "Survival" = "#50046d", "Death" = "#fcc47f"
  ),
  raw_value_col = colorRampPalette(
    c("#33286b", "#26828e", "#75d054", "#fae51f")
  )(9)
)
# Case 2: Psychosis_Disorder
dtGAP(
  data_all = Psychosis_Disorder,
  model = "party", show = "all",
  trans_type = "none", target_lab = "UNIQID"
)
}
}
