% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_tree.R
\name{compute_tree}
\alias{compute_tree}
\title{Compute Decision Tree Data for Plotting and Analysis}
\usage{
compute_tree(
  fit = NULL,
  model = c("rpart", "party", "C50", "caret", "cforest"),
  show = c("all", "train", "test"),
  data = NULL,
  target_lab = NULL,
  task = c("classification", "regression"),
  custom_layout = NULL,
  panel_space = 0.001
)
}
\arguments{
\item{fit}{A fitted decision party tree object.}

\item{model}{Character. Which implementation to use: one of "rpart", "party", "C50", or "caret".}

\item{show}{Character. Which subset to return:  "all", "train" or "test" .}

\item{data}{A data.frame containing the features and target for prediction.}

\item{target_lab}{Character. Name of the target column.}

\item{task}{Character. Task type: "classification" or "regression".}

\item{custom_layout}{Optional data.frame with custom node positions (columns: id, x, y).}

\item{panel_space}{Numeric. Vertical spacing between panels in layout.}
}
\value{
A list with components:
\itemize{
\item fit: the original fitted model
\item dat: data.frame of observations with node assignments and predictions
\item plot_data: data.frame of nodes with plotting variables and probabilities
\item layout: data.frame of node x/y positions
}
}
\description{
Builds and processes a decision tree model object to prepare data for plotting,
including layout positions and terminal node summaries.
need to run util.R first
}
\examples{
\donttest{
library(rpart)
library(partykit)
library(ggparty)
library(dplyr)
data <- add_data_type(
  data_all = Psychosis_Disorder
)
data <- prepare_features(
  data,
  target_lab = "UNIQID",
  task = "classification"
)
fit <- train_tree(
  data = data, target_lab = "UNIQID",
  model = "rpart"
)$fit
tree_res <- compute_tree(
  fit,
  model = "rpart", show = "all",
  data = data, target_lab = "UNIQID",
  task = "classification"
)
tree_res$dat
tree_res$plot_data
}
}
