% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_ht.R
\name{col_ht}
\alias{col_ht}
\title{Create Column Heatmap with Variable Importance}
\usage{
col_ht(
  fit,
  sorted_dat,
  var_imp,
  layout,
  include_var_imp = TRUE,
  col_var_imp = "orange",
  var_bar_width = 0.8,
  var_fontsize = 5,
  split_var_bg = "darkgreen",
  split_var_fontsize = 5,
  palette = "RdBu",
  n_colors = 11,
  show_col_prox = TRUE
)
}
\arguments{
\item{fit}{A fitted partykit tree object used to extract split variables.}

\item{sorted_dat}{List from \code{sorted_mat()}}

\item{var_imp}{Named numeric vector of variable importance scores.}

\item{layout}{List with layout dimensions}

\item{include_var_imp}{Logical; include importance barplot if TRUE (default TRUE).}

\item{col_var_imp}{Color for importance bars (default "orange").}

\item{var_bar_width}{Numeric width of bars (default 0.8).}

\item{var_fontsize}{Font size for importance text (default 5).}

\item{split_var_bg}{Background color for split variable names (default "darkgreen").}

\item{split_var_fontsize}{Font size for split variable names (default 5).}

\item{palette}{RColorBrewer palette for correlation heatmap (default "RdBu").}

\item{n_colors}{Number of colors in correlation scale (default 11).}

\item{show_col_prox}{Logical, whether to show column proximity.}
}
\value{
A \code{Heatmap} object from ComplexHeatmap.
}
\description{
Constructs a ComplexHeatmap object displaying feature-feature correlations
with optional variable importance barplots and split-variable highlighting.
}
\keyword{internal}
