% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProductStatus.R
\name{dpd_product_status}
\alias{dpd_product_status}
\title{Product Status}
\usage{
dpd_product_status(id, lang = c("en", "fr"))
}
\arguments{
\item{id}{Drug product code.}

\item{lang}{Language of the response. One of \code{"en"} or \code{"fr"} for English or
French, respectively.}
}
\value{
A \code{tibble} with columns:
\itemize{
\item \code{drug_code}: Code assigned to each drug product.
\item \code{expiration_date}: Latest expiry date of a product distributed in Canada,
where the product has since been discontinued by the company.
\item \code{external_status_code}: Code assigned to an external drug's status.
\item \code{history_date}: Historical date associated with a drug's status.
\item \code{lot_number}: Latest lot number of a product distributed in Canada, where
the product has since been discontinued by the company.
\item \code{original_market_date}: Original market date of a product.
}
}
\description{
The statuses listed below are a direct representation of the status available
in DPD Online Query and the description of each status is summarized below.
}
\examples{
dpd_product_status()
}
