% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DrugProduct.R
\name{dpd_drug_product}
\alias{dpd_drug_product}
\title{Drug Product}
\usage{
dpd_drug_product(id, din, brandname, status, lang = c("en", "fr"))
}
\arguments{
\item{id}{Drug product code.}

\item{din}{Drug Identification Number (DIN).}

\item{brandname}{Brand name.}

\item{status}{Drug product status. See \strong{Details} section.}

\item{lang}{Language of the response. One of \code{"en"} or \code{"fr"} for English or
French, respectively.}
}
\value{
A \code{tibble} with columns:
\itemize{
\item \code{ai_group_no}: Active Ingredient Group Number.
\item \code{brand_name}: Brand name for the drug product.
\item \code{class_name}: Therapeutic class of a drug product.
\item \code{descriptor}: Additional details or descriptions for a product,
if applicable.
\item \code{drug_code}: Code assigned to each drug product.
\item \code{drug_identification_number}: Drug Identification Number.
\item \code{number_of_ais}: Number of Active Ingredients in a drug product.
\item \code{company_name}: Company name.
\item \code{last_update_date}: Date is updated any time certain, but not all, key
fields are changed.
}
}
\description{
Basic information about the product, such as brand name and Drug
Identification Number.
}
\details{
\code{status} must be an integer, corresponding to the following statuses:
\itemize{
\item \code{1}: Approved
\item \code{2}: Marketed
\item \code{3}: Cancelled Pre Market
\item \code{4}: Cancelled Post Market
\item \code{6}: Dormant
\item \code{9}: Cancelled (Unreturned Annual)
\item \code{10}: Cancelled (Safety Issue)
\item \code{11}: Authorized By Interim Order
\item \code{12}: Authorization By Interim Order Revoked
\item \code{13}: Restricted Access
\item \code{14}: Authorization By Interim Order Expired
\item \code{15}: Cancelled (Transitioned to Biocides)
}
}
\examples{
dpd_drug_product(id = 2049)

dpd_drug_product(din = '00326925')

dpd_drug_product(brandname = "cidyl")

dpd_drug_product(status = 1)
}
